// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The model representing a single DHL configuration.
 */
Ext.define('Shopware.apps.ViisonDHLConfig.model.DHL', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Ext.data.Model',

    /**
     * The fields used for this model.
     */
    fields: [].concat(Ext.JSON.decode('{$shippingConfigFields|@json_encode|escape:"javascript"}') || []),

    /**
     * Configure the data communication.
     */
    proxy: {
        type: 'ajax',
        api: {
            create: '{url controller="ViisonDHLConfig" action="createConfiguration"}',
            update: '{url controller="ViisonDHLConfig" action="updateConfiguration"}',
            destroy: '{url controller="ViisonDHLConfig" action="destroyConfiguration"}',
        },
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
    },

});
