// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The DHL configuration form panel, which is displayed in the window that is accessible via the
 * button in the plugin description in the plugin manager.
 */
// {namespace name="backend/viison_dhl_config/config"}
Ext.define('Shopware.apps.ViisonDHLConfig.view.Panel', {

    extend: 'Shopware.apps.ViisonShippingCommonConfig.view.Panel',

    xtype: 'viisondhlconfig-panel',

    /**
     * Store used for countries that are supported for DHL & DHL Express shipping
     * @default null
     * @object
     */
    supportedSenderCountriesStore: null,

    /**
     * Constant definitions for the GDPR dropdown (send mail of phone to provider) values.
     */
    GDPR_ALWAYS: '{$viisonGdprConfig.always}',
    GDPR_NEVER: '{$viisonGdprConfig.never}',
    GDPR_CUSTOMER_CHOICE: '{$viisonGdprConfig.customerChoice}',

    /**
     * Contains all snippets for the view component.
     */
    snippets: {
        items: {
            senderName: {
                label: '{s name="panel/items/sender_name/label"}{/s}',
                help: '{s name="panel/items/sender_name/help"}{/s}',
            },
            senderName2: {
                label: '{s name="panel/items/sender_name_2/label"}{/s}',
                help: '{s name="panel/items/sender_name_2/help"}{/s}',
            },
            streetName: {
                label: '{s name="panel/items/street_name/label"}{/s}',
                help: '{s name="panel/items/street_name/help"}{/s}',
            },
            streetNumber: {
                label: '{s name="panel/items/street_number/label"}{/s}',
                help: '{s name="panel/items/street_number/help"}{/s}',
            },
            zipCode: {
                label: '{s name="panel/items/zip_code/label"}{/s}',
                help: '{s name="panel/items/zip_code/help"}{/s}',
            },
            city: {
                label: '{s name="panel/items/city/label"}{/s}',
                help: '{s name="panel/items/city/help"}{/s}',
            },
            supportedCountries: {
                title: '{s name="panel/items/supported_countries/title"}{/s}',
                label: '{s name="panel/items/supported_countries/label"}{/s}',
                help: '{s name="panel/items/supported_countries/help"}{/s}',
            },
            contactPerson: {
                label: '{s name="panel/items/contact_person/label"}{/s}',
                help: '{s name="panel/items/contact_person/help"}{/s}',
            },
            email: {
                label: '{s name="panel/items/email/label"}{/s}',
                help: '{s name="panel/items/email/help"}{/s}',
            },
            phoneNumber: {
                label: '{s name="panel/items/phone_number/label"}{/s}',
                help: '{s name="panel/items/phone_number/help"}{/s}',
            },
            sendersCustomsReference: {
                label: '{s name="panel/items/senders_customs_reference/label"}{/s}',
                help: '{s name="panel/items/senders_customs_reference/help"}{/s}',
            },
            username: {
                label: '{s name="panel/items/username/label"}{/s}',
                help: '{s name="panel/items/username/help"}{/s}',
            },
            password: {
                label: '{s name="panel/items/password/label"}{/s}',
                help: '{s name="panel/items/password/help"}{/s}',
            },
            useTestingWebservice: {
                label: '{s name="panel/items/use_testing_webservice/label"}{/s}',
                help: '{s name="panel/items/use_testing_webservice/help"}{/s}',
            },
            verifyCredentialsButton: {
                text: '{s name="panel/items/verify_credentials_button/text"}{/s}',
            },
            scrapDHLData: {
                text: '{s name="panel/items/data_scraper_button/text"}{/s}',
            },
            ekp: {
                label: '{s name="panel/items/ekp/label"}{/s}',
                help: '{s name="panel/items/ekp/help"}{/s}',
            },
            printOnlyIfCodeable: {
                label: '{s name="panel/items/print_only_if_codeable/label"}{/s}',
                help: '{s name="panel/items/print_only_if_codeable/help"}{/s}',
            },
            partnerIdSeparator: {
                label: '{s name="panel/items/partner_id_separator/label"}{/s}',
            },
            dhlCustomerPortalSeparator: {
                label: '{s name="panel/items/dhl_customer_portal_separator/label"}{/s}',
            },
            dhlCustomerPortalInformation: {
                label: '{s name="panel/items/dhl_customer_portal_information/label"}{/s}',
            },
            senderAddressSeparator: {
                label: '{s name="panel/items/sender_address_separator/label"}{/s}',
            },
            partnerIdEPN: {
                label: '{s name="panel/items/partner_id_epn/label"}{/s}',
                help: '{s name="panel/items/partner_id_epn/help"}{/s}',
            },
            partnerIdBPC: {
                label: '{s name="panel/items/partner_id_bpc/label"}{/s}',
                help: '{s name="panel/items/partner_id_bpc/help"}{/s}',
            },
            partnerIdEPO: {
                label: '{s name="panel/items/partner_id_epo/label"}{/s}',
                help: '{s name="panel/items/partner_id_epo/help"}{/s}',
            },
            partnerIdEPI: {
                label: '{s name="panel/items/partner_id_epi/label"}{/s}',
                help: '{s name="panel/items/partner_id_epi/help"}{/s}',
            },
            partnerIdBPI: {
                label: '{s name="panel/items/partner_id_bpi/label"}{/s}',
                help: '{s name="panel/items/partner_id_bpi/help"}{/s}',
            },
            partnerIdWAP: {
                label: '{s name="panel/items/partner_id_wap/label"}{/s}',
                help: '{s name="panel/items/partner_id_wap/help"}{/s}',
            },
            partnerIdWPI: {
                label: '{s name="panel/items/partner_id_wpi/label"}{/s}',
                help: '{s name="panel/items/partner_id_wpi/help"}{/s}',
            },
            expressSeparator: {
                label: '{s name="panel/items/express_separator/label"}{/s}',
            },
            expressAccountNumber: {
                label: '{s name="panel/items/express_account_number/label"}{/s}',
                help: '{s name="panel/items/express_account_number/help"}{/s}',
            },
            expressUsername: {
                label: '{s name="panel/items/express_username/label"}{/s}',
                help: '{s name="panel/items/express_username/help"}{/s}',
            },
            expressPassword: {
                label: '{s name="panel/items/express_password/label"}{/s}',
                help: '{s name="panel/items/express_password/help"}{/s}',
            },
            defaultPackageLength: {
                label: '{s name="panel/items/default_package_length/label"}{/s}',
                help: '{s name="panel/items/default_package_length/help"}{/s}',
            },
            defaultPackageWidth: {
                label: '{s name="panel/items/default_package_width/label"}{/s}',
                help: '{s name="panel/items/default_package_width/help"}{/s}',
            },
            defaultPackageHeight: {
                label: '{s name="panel/items/default_package_height/label"}{/s}',
                help: '{s name="panel/items/default_package_height/help"}{/s}',
            },
            weightSeparator: {
                label: '{s name="panel/items/weight_separator/label"}{/s}',
            },
            miscSeperator: {
                label: '{s name="panel/items/misc_items/label"}{/s}',
            },
            defaultShipmentWeightEPN: {
                label: '{s name="panel/items/default_shipment_weight_epn/label"}{/s}',
                help: '{s name="panel/items/default_shipment_weight_epn/help"}{/s}',
            },
            defaultShipmentWeightEPI: {
                label: '{s name="panel/items/default_shipment_weight_epi/label"}{/s}',
                help: '{s name="panel/items/default_shipment_weight_epi/help"}{/s}',
            },
            defaultShipmentWeightEPO: {
                label: '{s name="panel/items/default_shipment_weight_epo/label"}{/s}',
                help: '{s name="panel/items/default_shipment_weight_epo/help"}{/s}',
            },
            defaultShipmentWeightBPC: {
                label: '{s name="panel/items/default_shipment_weight_bpc/label"}{/s}',
                help: '{s name="panel/items/default_shipment_weight_bpc/help"}{/s}',
            },
            defaultShipmentWeightBPI: {
                label: '{s name="panel/items/default_shipment_weight_bpi/label"}{/s}',
                help: '{s name="panel/items/default_shipment_weight_bpi/help"}{/s}',
            },
            defaultShipmentWeightWAP: {
                label: '{s name="panel/items/default_shipment_weight_wap/label"}{/s}',
                help: '{s name="panel/items/default_shipment_weight_wap/help"}{/s}',
            },
            defaultShipmentWeightWPI: {
                label: '{s name="panel/items/default_shipment_weight_wpi/label"}{/s}',
                help: '{s name="panel/items/default_shipment_weight_wpi/help"}{/s}',
            },
            defaultShipmentWeightEXP: {
                label: '{s name="panel/items/default_shipment_weight_exp/label"}{/s}',
                help: '{s name="panel/items/default_shipment_weight_exp/help"}{/s}',
            },
            calculateWeight: {
                label: '{s name="panel/items/calculate_weight/label"}{/s}',
                help: '{s name="panel/items/calculate_weight/help"}{/s}',
            },
            fillerSurcharge: {
                label: '{s name="panel/items/filler_surcharge/label"}{/s}',
                help: '{s name="panel/items/filler_surcharge/help"}{/s}',
            },
            packagingSurcharge: {
                label: '{s name="panel/items/packaging_surcharge/label"}{/s}',
                help: '{s name="panel/items/packaging_surcharge/help"}{/s}',
            },
            exportSeparator: {
                label: '{s name="panel/items/export_separator/label"}{/s}',
            },
            exportTypeOfShipment: {
                label: '{s name="panel/items/export_type_of_shipment/label"}{/s}',
                help: '{s name="panel/items/export_type_of_shipment/help"}{/s}',
                other: '{s name="panel/items/export_type_of_shipment/other"}{/s}',
                present: '{s name="panel/items/export_type_of_shipment/present"}{/s}',
                commercial_sample: '{s name="panel/items/export_type_of_shipment/commercial_sample"}{/s}',
                document: '{s name="panel/items/export_type_of_shipment/document"}{/s}',
                return_of_goods: '{s name="panel/items/export_type_of_shipment/return_of_goods"}{/s}',
                commercial_goods: '{s name="panel/items/export_type_of_shipment/commercial_goods"}{/s}',
            },
            exportDocumentTypeDescription: {
                label: '{s name="panel/items/export_document_type_description/label"}{/s}',
                help: '{s name="panel/items/export_document_type_description/help"}{/s}',
            },
            exportIncoterm: {
                label: '{s name="panel/items/export_incoterm/label"}{/s}',
                help: '{s name="panel/items/export_incoterm/help"}{/s}',
            },
            exportDescription: {
                label: '{s name="panel/items/export_description/label"}{/s}',
                help: '{s name="panel/items/export_description/help"}{/s}',
            },
            exportPlaceOfCommittal: {
                label: '{s name="panel/items/export_place_of_committal/label"}{/s}',
                help: '{s name="panel/items/export_place_of_committal/help"}{/s}',
            },
            notificationEmailSeparator: {
                label: '{s name="panel/items/notification_email_description/label"}{/s}',
            },
            sendDispatchNotification: {
                label: '{s name="panel/items/send_dispatch_notification/label"}{/s}',
                help: '{s name="panel/items/send_dispatch_notification/help"}{/s}',
            },
            dispatchNotificationSender: {
                label: '{s name="panel/items/dispatch_notification_sender/label"}{/s}',
                help: '{s name="panel/items/dispatch_notification_sender/help"}{/s}',
            },
            sendDeliveryNotification: {
                label: '{s name="panel/items/send_delivery_notification/label"}{/s}',
                help: '{s name="panel/items/send_delivery_notification/help"}{/s}',
            },
            cashOnDeliverySeparator: {
                label: '{s name="panel/items/cash_on_delivery_separator/label"}{/s}',
            },
            bankAccountOwner: {
                label: '{s name="panel/items/bank_account_owner/label"}{/s}',
                help: '{s name="panel/items/bank_account_owner/help"}{/s}',
            },
            bankName: {
                label: '{s name="panel/items/bank_name/label"}{/s}',
                help: '{s name="panel/items/bank_name/help"}{/s}',
            },
            bankIBAN: {
                label: '{s name="panel/items/bank_iban/label"}{/s}',
                help: '{s name="panel/items/bank_iban/help"}{/s}',
            },
            onlineRetoureSeparator: {
                label: '{s name="panel/items/online_retoure_separator/label"}{/s}',
            },
            onlineRetourePortalName: {
                label: '{s name="panel/items/online_retoure_portal_name/label"}{/s}',
                help: '{s name="panel/items/online_retoure_portal_name/help"}{/s}',
            },
            autoSendReturnLabel: {
                label: '{s name="panel/items/auto_send_return_label/label"}{/s}',
                help: '{s name="panel/items/auto_send_return_label/help"}{/s}',
                validationErrorMessage: '{s name="panel/items/auto_send_return_label/validation_error_message"}{/s}',
            },
            sendMailConfiguration: {
                label: '{s name="panel/items/send_mail_configuration/label"}{/s}',
                help: '{s name="panel/items/send_mail_configuration/help"}{/s}',
                never: '{s name="panel/items/send_mail_configuration/never"}{/s}',
                always: '{s name="panel/items/send_mail_configuration/always"}{/s}',
                customerChoice: '{s name="panel/items/send_mail_configuration/customer_choice"}{/s}',
            },
            sendPhoneConfiguration: {
                label: '{s name="panel/items/send_phone_configuration/label"}{/s}',
                help: '{s name="panel/items/send_phone_configuration/help"}{/s}',
                never: '{s name="panel/items/send_phone_configuration/never"}{/s}',
                always: '{s name="panel/items/send_phone_configuration/always"}{/s}',
            },
        },
        groupValidationFailed: '{s name="panel/group_validation_failed"}{/s}',
        groupDependencyValidationFailed: '{s name="panel/group_dependency_validation_failed"}{/s}',
        disallowBlankIfCheckedValidationFailed: '{s name="panel/disallow_blank_if_checked_validation_failed"}{/s}',
    },

    /**
     * @Override
     */
    initComponent: function () {
        var me = this;

        me.callParent(arguments);

        /** @Override from ShippingCommon */
        if (me.sharedConfigFields) {
            me.sharedConfigFields.cashOnDeliveryPaymentMeansSection.activate = true;
            me.sharedConfigFields.cashOnDeliveryPaymentMeansSection.insertAfterSection = 'bankIBAN';
        }

        this.incotermStore = Ext.getStore('viisonDHLIncotermStore') || Ext.create('Shopware.apps.ViisonDHLTermsOfTrade.store.Incoterm');
    },

    /**
     * If groups need to be filled out if another group has entries, this
     * dependency can be expressed here. These dependencies are enforced
     * by the group validator.
     *
     * The current settings mean: the 'base' group needs to be filled out
     * if either the group 'international-shipment' or 'cash-on-delivery' is set
     */
    groupDependencies: {
        base: [
            'international-shipment',
            'cash-on-delivery',
        ],
    },

    /**
     * Creates and returns an array of all input fields belonging to this configuration form.
     *
     * @return An array containing all created input fields.
     */
    createItems: function () {
        var me = this;

        var onlineRetourePortalNames = [];
        var items = [];

        var retoureCountries = me.retoureCountries;
        Ext.each(retoureCountries, function (country) {
            onlineRetourePortalNames.push({
                xtype: 'base-element-text',
                name: 'onlineRetourePortalName' + country.toUpperCase(),
                fieldLabel: me.snippets.items.onlineRetourePortalName.label + ' ' + me.commonSnippets.countryNames[country.toUpperCase()],
                helpText: me.snippets.items.onlineRetourePortalName.help,
                maxLength: 255,
            });
        });

        /**
         * Create array sections for the config fields
         *
         * NOTE: The sections are separated by the section name
         */
        var countrySimilarItems = me.createCountrySpecificItems();

        var dhlCustomerPortalItems = [{
            xtype: 'container',
            margin: '15 0 10 0',
            cls: 'viison-label-seperator-dhl-login',
            items: [{
                xtype: 'label',
                text: me.snippets.items.dhlCustomerPortalSeparator.label,
            }],
        }, {
            xtype: 'base-element-text',
            name: 'username',
            fieldLabel: me.snippets.items.username.label,
            helpText: me.snippets.items.username.help,
            maxLength: 255,
            group: 'base',
            validator: me.groupValidator,
            // NOTE: ShippingCommon overrides the change listener of every field via fieldChange function -.-
        }, {
            xtype: 'base-element-text',
            name: 'password',
            fieldLabel: me.snippets.items.password.label,
            helpText: me.snippets.items.password.help,
            maxLength: 255,
            inputType: 'password',
            group: 'base',
            validator: me.groupValidator,
            // NOTE: ShippingCommon overrides the change listener of every field via fieldChange function -.-
        }, {
            xtype: 'base-element-boolean',
            name: 'useTestingWebservice',
            fieldLabel: me.snippets.items.useTestingWebservice.label,
            helpText: me.snippets.items.useTestingWebservice.help,
            checked: false,
        }, {
            xtype: 'container',
            margin: '10 15 10 0',
            items: [{
                xtype: 'label',
                html: me.snippets.items.dhlCustomerPortalInformation.label,
            }],
        }, {
            xtype: 'container',
            cls: 'viison-button-verify-credentials',
            margin: '10 0 10 0',
            items: [{
                xtype: 'base-element-button',
                action: 'verify',
                text: me.snippets.items.verifyCredentialsButton.text,
                listeners: {
                    scope: this,
                    click: function (button) {
                        var shopId = button.up().shopId;
                        button.fireEvent('verifyCredentials', button, shopId, this.getCredentials(shopId));
                    },
                },
            }],
        }];

        var supportedCountries = [{
            xtype: 'container',
            margin: '15 0 10 0',
            items: [{
                xtype: 'label',
                text: me.snippets.items.supportedCountries.title,
            }],
        }, {
            xtype: 'combobox',
            name: 'countryiso',
            itemId: 'countryiso',
            fieldLabel: me.snippets.items.supportedCountries.label,
            helpText: me.snippets.items.supportedCountries.help,
            valueField: 'countryiso',
            displayField: 'countryname',
            queryMode: 'local',
            mode: 'local',
            editable: false,
            store: me.supportedSenderCountriesStore,
            tpl: me.createCountryBoxTemplate(),
        }];

        var senderAddressItems = [{
            xtype: 'container',
            margin: '15 0 10 0',
            items: [{
                xtype: 'label',
                text: me.snippets.items.senderAddressSeparator.label,
            }],
        }, {
            xtype: 'base-element-text',
            name: 'senderName',
            fieldLabel: me.snippets.items.senderName.label,
            helpText: me.snippets.items.senderName.help,
            maxLength: 30,
            group: 'base',
            validator: me.groupValidator,
        }, {
            xtype: 'base-element-text',
            name: 'senderName2',
            fieldLabel: me.snippets.items.senderName2.label,
            helpText: me.snippets.items.senderName2.help,
            maxLength: 30,
            group: 'base',
        }, {
            xtype: 'base-element-text',
            name: 'streetName',
            fieldLabel: me.snippets.items.streetName.label,
            helpText: me.snippets.items.streetName.help,
            maxLength: 30,
            group: 'base',
            validator: me.groupValidator,
        }, {
            xtype: 'base-element-text',
            name: 'streetNumber',
            fieldLabel: me.snippets.items.streetNumber.label,
            helpText: me.snippets.items.streetNumber.help,
            maxLength: 30,
            group: 'base',
            validator: me.groupValidator,
        }, {
            xtype: 'base-element-text',
            name: 'zipCode',
            fieldLabel: me.snippets.items.zipCode.label,
            helpText: me.snippets.items.zipCode.help,
            maxLength: 30,
            group: 'base',
            validator: me.groupValidator,
            maskRe: new RegExp('[\\da-zA-Z\\s]'),
        }, {
            xtype: 'base-element-text',
            name: 'city',
            fieldLabel: me.snippets.items.city.label,
            helpText: me.snippets.items.city.help,
            maxLength: 30,
            group: 'base',
            validator: me.groupValidator,
        }, {
            xtype: 'base-element-text',
            name: 'contactPerson',
            fieldLabel: me.snippets.items.contactPerson.label,
            helpText: me.snippets.items.contactPerson.help,
            maxLength: 30,
            group: 'base',
            validator: me.groupValidator,
        }, {
            xtype: 'base-element-text',
            name: 'email',
            fieldLabel: me.snippets.items.email.label,
            helpText: me.snippets.items.email.help,
            maxLength: 50,
            vtype: 'email',
            group: 'base',
            validator: me.groupValidator,
        }, {
            xtype: 'base-element-text',
            name: 'phoneNumber',
            fieldLabel: me.snippets.items.phoneNumber.label,
            helpText: me.snippets.items.phoneNumber.help,
            maxLength: 30,
            group: 'base',
            validator: me.groupValidator,
            maskRe: new RegExp('[\\d\\+]'),
        }];

        var miscItems = [{
            xtype: 'container',
            margin: '15 0 10 0',
            items: [{
                xtype: 'label',
                text: me.snippets.items.miscSeperator.label,
            }],
        }, {
            xtype: 'base-element-boolean',
            name: 'printOnlyIfCodeable',
            fieldLabel: me.snippets.items.printOnlyIfCodeable.label,
            helpText: me.snippets.items.printOnlyIfCodeable.help,
            checked: false,
        }];

        var exportItems = [{
            xtype: 'container',
            margin: '15 0 10 0',
            items: [{
                xtype: 'label',
                text: me.snippets.items.exportSeparator.label,
            }],
        }, {
            xtype: 'combobox',
            name: 'exportTypeOfShipment',
            fieldLabel: me.snippets.items.exportTypeOfShipment.label,
            helpText: me.snippets.items.exportTypeOfShipment.help,
            valueField: 'value',
            displayField: 'displayName',
            queryMode: 'local',
            mode: 'local',
            editable: false,
            emptyText: '-',
            store: Ext.create('Ext.data.Store', {
                fields: [
                    { name: 'value', type: 'string' },
                    { name: 'displayName', type: 'string' },
                ],
                data: [
                    { value: null, displayName: '-' },
                    { value: 'OTHER', displayName: me.snippets.items.exportTypeOfShipment.other },
                    { value: 'PRESENT', displayName: me.snippets.items.exportTypeOfShipment.present },
                    { value: 'COMMERCIAL_SAMPLE', displayName: me.snippets.items.exportTypeOfShipment.commercial_sample },
                    { value: 'DOCUMENT', displayName: me.snippets.items.exportTypeOfShipment.document },
                    { value: 'RETURN_OF_GOODS', displayName: me.snippets.items.exportTypeOfShipment.return_of_goods },
                    { value: 'COMMERCIAL_GOODS', displayName: me.snippets.items.exportTypeOfShipment.commercial_goods },
                ],
            }),
            group: 'international-shipment',
            validator: me.groupValidator,
        }, {
            xtype: 'base-element-text',
            name: 'exportDocumentTypeDescription',
            fieldLabel: me.snippets.items.exportDocumentTypeDescription.label,
            helpText: me.snippets.items.exportDocumentTypeDescription.help,
            maxLength: 50,
            optionalGroupField: true,
            group: 'international-shipment',
            validator: me.groupValidator,
        }, {
            xtype: 'combobox',
            name: 'exportIncoterm',
            fieldLabel: me.snippets.items.exportIncoterm.label,
            helpText: me.snippets.items.exportIncoterm.help,
            valueField: 'name',
            displayField: 'description',
            queryMode: 'local',
            mode: 'local',
            editable: false,
            emptyText: '-',
            store: this.incotermStore,
            group: 'international-shipment',
            validator: me.groupValidator,
        }, {
            xtype: 'base-element-text',
            name: 'exportDescription',
            fieldLabel: me.snippets.items.exportDescription.label,
            helpText: me.snippets.items.exportDescription.help,
            minLength: 2,
            allowBlank: true,
            group: 'international-shipment',
            validator: me.groupValidator,
        }, {
            xtype: 'base-element-text',
            name: 'exportPlaceOfCommittal',
            fieldLabel: me.snippets.items.exportPlaceOfCommittal.label,
            helpText: me.snippets.items.exportPlaceOfCommittal.help,
            optionalGroupField: true,
            group: 'international-shipment',
            validator: me.groupValidator,
        }, {
            xtype: 'base-element-text',
            name: 'sendersCustomsReference',
            fieldLabel: me.snippets.items.sendersCustomsReference.label,
            helpText: me.snippets.items.sendersCustomsReference.help,
            maxLength: 35,
            optionalGroupField: true,
            group: 'international-shipment',
            validator: me.groupValidator,
        }];

        var notificationEmailItems = [{
            xtype: 'container',
            margin: '15 0 10 0',
            items: [{
                xtype: 'label',
                text: me.snippets.items.notificationEmailSeparator.label,
            }],
        }, {
            xtype: 'combobox',
            name: 'gdprPhoneConfiguration',
            fieldLabel: this.snippets.items.sendPhoneConfiguration.label,
            helpText: this.snippets.items.sendPhoneConfiguration.help,
            valueField: 'value',
            displayField: 'displayName',
            queryMode: 'local',
            mode: 'local',
            editable: false,
            store: Ext.create('Ext.data.Store', {
                fields: [
                    { name: 'value', type: 'string' },
                    { name: 'displayName', type: 'string' },
                ],
                data: [
                    { value: this.GDPR_NEVER, displayName: this.snippets.items.sendPhoneConfiguration.never },
                    { value: this.GDPR_ALWAYS, displayName: this.snippets.items.sendPhoneConfiguration.always },
                ],
            }),
        }, {
            xtype: 'combobox',
            name: 'gdprMailConfiguration',
            fieldLabel: this.snippets.items.sendMailConfiguration.label,
            helpText: this.snippets.items.sendMailConfiguration.help,
            valueField: 'value',
            displayField: 'displayName',
            queryMode: 'local',
            mode: 'local',
            editable: false,
            store: Ext.create('Ext.data.Store', {
                fields: [
                    { name: 'value', type: 'string' },
                    { name: 'displayName', type: 'string' },
                ],
                data: [
                    { value: this.GDPR_NEVER, displayName: this.snippets.items.sendMailConfiguration.never },
                    { value: this.GDPR_ALWAYS, displayName: this.snippets.items.sendMailConfiguration.always },
                    { value: this.GDPR_CUSTOMER_CHOICE, displayName: this.snippets.items.sendMailConfiguration.customerChoice },
                ],
            }),
            listeners: {
                change: this.onGdprConfigChange,
                scope: this,
            },
        }, {
            xtype: 'base-element-boolean',
            name: 'sendDispatchNotification',
            fieldLabel: me.snippets.items.sendDispatchNotification.label,
            helpText: me.snippets.items.sendDispatchNotification.help,
            checked: false,
            influencesValidationOf: ['dispatchNotificationSender'],
        }, {
            xtype: 'base-element-text',
            name: 'dispatchNotificationSender',
            fieldLabel: me.snippets.items.dispatchNotificationSender.label,
            helpText: me.snippets.items.dispatchNotificationSender.help,
            maxLength: 50,
            checkboxName: 'sendDispatchNotification',
            vtype: 'email',
            validator: me.disallowBlankIfCheckedValidator,
        }, {
            xtype: 'base-element-boolean',
            name: 'sendDeliveryNotification',
            fieldLabel: me.snippets.items.sendDeliveryNotification.label,
            helpText: me.snippets.items.sendDeliveryNotification.help,
            checked: false,
        }];

        var cashOnDeliveryItems = [{
            xtype: 'container',
            margin: '15 0 10 0',
            items: [{
                xtype: 'label',
                text: me.snippets.items.cashOnDeliverySeparator.label,
            }],
        }, {
            xtype: 'base-element-text',
            name: 'bankAccountOwner',
            fieldLabel: me.snippets.items.bankAccountOwner.label,
            helpText: me.snippets.items.bankAccountOwner.help,
            maxLength: 30,
            group: 'cash-on-delivery',
            validator: me.groupValidator,
        }, {
            xtype: 'base-element-text',
            name: 'bankName',
            fieldLabel: me.snippets.items.bankName.label,
            helpText: me.snippets.items.bankName.help,
            maxLength: 30,
            group: 'cash-on-delivery',
            validator: me.groupValidator,
        }, {
            xtype: 'base-element-text',
            name: 'bankIBAN',
            fieldLabel: me.snippets.items.bankIBAN.label,
            helpText: me.snippets.items.bankIBAN.help,
            maxLength: 34,
            group: 'cash-on-delivery',
            validator: me.groupValidator,
        }];

        var expressItems = [{
            xtype: 'container',
            margin: '15 0 10 0',
            items: [{
                xtype: 'label',
                text: me.snippets.items.expressSeparator.label,
            }],
        }, {
            xtype: 'base-element-text',
            name: 'expressAccountNumber',
            fieldLabel: me.snippets.items.expressAccountNumber.label,
            helpText: me.snippets.items.expressAccountNumber.help,
            maxLength: 9,
        }, {
            xtype: 'base-element-text',
            name: 'expressUsername',
            fieldLabel: me.snippets.items.expressUsername.label,
            helpText: me.snippets.items.expressUsername.help,
            maxLength: 255,
        }, {
            xtype: 'base-element-text',
            name: 'expressPassword',
            fieldLabel: me.snippets.items.expressPassword.label,
            helpText: me.snippets.items.expressPassword.help,
            maxLength: 255,
            inputType: 'password',
            group: 'base',
        }, {
            xtype: 'base-element-text',
            name: 'defaultPackageLength',
            fieldLabel: me.snippets.items.defaultPackageLength.label,
            helpText: me.snippets.items.defaultPackageLength.help,
            group: 'package-dimensions',
            validator: me.groupValidator,
            maskRe: new RegExp('[\\d]'),
        }, {
            xtype: 'base-element-text',
            name: 'defaultPackageWidth',
            fieldLabel: me.snippets.items.defaultPackageWidth.label,
            helpText: me.snippets.items.defaultPackageWidth.help,
            group: 'package-dimensions',
            validator: me.groupValidator,
            maskRe: new RegExp('[\\d]'),
        }, {
            xtype: 'base-element-text',
            name: 'defaultPackageHeight',
            fieldLabel: me.snippets.items.defaultPackageHeight.label,
            helpText: me.snippets.items.defaultPackageHeight.help,
            group: 'package-dimensions',
            validator: me.groupValidator,
            maskRe: new RegExp('[\\d]'),
        }];

        var onlineRetourePortalItems = [{
            xtype: 'container',
            margin: '15 0 10 0',
            items: [{
                xtype: 'label',
                text: me.snippets.items.onlineRetoureSeparator.label,
            }],
        }].concat(onlineRetourePortalNames).concat([{
            xtype: 'base-element-boolean',
            name: 'autoSendReturnLabel',
            fieldLabel: me.snippets.items.autoSendReturnLabel.label,
            helpText: me.snippets.items.autoSendReturnLabel.help,
            checked: false,
            referencedGroup: 'retoure',
            validator: me.allowOnlyIfGroupFilledValidator,
            validationErrorMessage: me.snippets.items.autoSendReturnLabel.validationErrorMessage,
        }]);

        /**
         * Join (Concat) all sub-arrays in one
         *
         * NOTE: [].concat.apply is used because iw will consume lesser memory
         *       and is faster because it is executed via the apply function
         */
        items = [].concat.apply([], [
            items,
            dhlCustomerPortalItems,
            supportedCountries,
            countrySimilarItems.partnerIdItems,
            senderAddressItems,
            countrySimilarItems.defaultShippmentItems,
            miscItems,
            exportItems,
            notificationEmailItems,
            cashOnDeliveryItems,
            expressItems,
            onlineRetourePortalItems,
        ]);

        return items;
    },

    /**
     * Disable/Enable the dispatch and delivery notification checkbox if no customer data is allowed to be transmitted.
     *
     * @param field
     * @param newValue
     */
    onGdprConfigChange: function (field, newValue) {
        this.updateDispatchAndDeliveryContainerVisibility(field.shopId, newValue === this.GDPR_NEVER);
    },

    updateDispatchAndDeliveryContainerVisibility: function (shopId, disabled) {
        var form = this.getForm();
        var sendDispatchNotificationContainer = form.findField(this.makeShopQualifiedFieldName(shopId, 'sendDispatchNotification'));
        var sendDeliveryNotificationContainer = form.findField(this.makeShopQualifiedFieldName(shopId, 'sendDeliveryNotification'));
        var dispatchNotificationSenderContainer = form.findField(this.makeShopQualifiedFieldName(shopId, 'dispatchNotificationSender'));
        sendDispatchNotificationContainer.setDisabled(disabled);
        sendDeliveryNotificationContainer.setDisabled(disabled);
        dispatchNotificationSenderContainer.setDisabled(disabled);
    },

    /**
     * Create Country code items that are from content similar
     *
     * @returns array(defaultShippmentItems: *[], partnerIdItems: *[])
     */
    createCountrySpecificItems: function () {
        var me = this;
        var extensions = ['EPN', 'EPO', 'BPC', 'EPI', 'BPI', 'WAP', 'WPI'];

        var partnerIdItems = [{
            xtype: 'container',
            margin: '15 0 10 0',
            cls: 'viison-label-seperator-EKP',
            items: [{
                xtype: 'label',
                text: me.snippets.items.partnerIdSeparator.label,
            }],
        }, {
            xtype: 'container',
            cls: 'viison-button-scraper-fill-data',
            margin: '10 0 10 0',
            items: [{
                xtype: 'base-element-button',
                action: 'scraperFillData',
                text: this.snippets.items.scrapDHLData.text,
                listeners: {
                    scope: this,
                    click: function (button) {
                        var shopId = button.up().shopId;
                        button.fireEvent('scrapData', button, shopId, this.getCredentials(shopId));
                    },
                },
            }],
        }, {
            xtype: 'base-element-text',
            name: 'EKP',
            fieldLabel: me.snippets.items.ekp.label,
            helpText: me.snippets.items.ekp.help,
            minLength: 10,
            maxLength: 10,
            group: 'base',
            validator: me.groupValidator,
            maskRe: new RegExp('[\\d]'),
        }];

        var defaultShippmentWeightItems = [{
            xtype: 'container',
            margin: '15 0 10 0',
            items: [{
                xtype: 'label',
                text: me.snippets.items.weightSeparator.label,
            }],
        }];

        for (var i = 0, length = extensions.length; i < length; i += 1) {
            partnerIdItems.push({
                xtype: 'base-element-text',
                name: 'partnerId' + extensions[i],
                fieldLabel: me.snippets.items['partnerId' + extensions[i]].label,
                helpText: me.snippets.items['partnerId' + extensions[i]].help,
                minLength: 2,
                maxLength: 2,
                allowBlank: true,
                maskRe: new RegExp('[a-zA-Z\\d]'),
            });

            defaultShippmentWeightItems.push({
                xtype: 'x-custom-field-weight',
                name: 'defaultShipmentWeight' + extensions[i],
                fieldLabel: me.snippets.items['defaultShipmentWeight' + extensions[i]].label,
                helpText: me.snippets.items['defaultShipmentWeight' + extensions[i]].help,
                defaultSubmitValue: 0,
                allowBlank: false,
            });
        }

        // Standard fields that are always visible
        defaultShippmentWeightItems.push({
            xtype: 'x-custom-field-weight',
            name: 'defaultShipmentWeightEXP',
            fieldLabel: me.snippets.items.defaultShipmentWeightEXP.label,
            helpText: me.snippets.items.defaultShipmentWeightEXP.help,
            defaultSubmitValue: 0,
            allowBlank: false,
        }, {
            xtype: 'base-element-boolean',
            name: 'calculateWeight',
            fieldLabel: me.snippets.items.calculateWeight.label,
            helpText: me.snippets.items.calculateWeight.help,
            checked: false,
        }, {
            xtype: 'x-custom-field-weight',
            name: 'fillerSurcharge',
            fieldLabel: me.snippets.items.fillerSurcharge.label,
            helpText: me.snippets.items.fillerSurcharge.help,
            defaultSubmitValue: 0,
            allowBlank: false,
        }, {
            xtype: 'x-custom-field-weight',
            name: 'packagingSurcharge',
            fieldLabel: me.snippets.items.packagingSurcharge.label,
            helpText: me.snippets.items.packagingSurcharge.help,
            defaultSubmitValue: 0,
            allowBlank: false,
        });

        return {
            defaultShippmentItems: defaultShippmentWeightItems,
            partnerIdItems: partnerIdItems,
        };
    },

    /**
     * Create template to grope countries by shipping type.
     *
     * BIG NOTE:  // {literal} var templateText = '{[this.groupProductsByCountryName(values)]}'; // {/literal}
     *           this is a standard approach for minified, see https://github.com/VIISON/minimal-smartyness for more info.
     *
     * @returns Ext.XTemplate
     */
    createCountryBoxTemplate: function () {
        // {literal}
        var templateText = '{[this.groupProductsByCountryName(values)]}';
        // {/literal}
        var template = Ext.create('Ext.XTemplate',
            templateText,
            {
                groupProductsByCountryName: function (values) {
                    var html = '';
                    var tempGroupingTitle = null;
                    var groupingTitle = null;

                    if (!values) {
                        return null;
                    }

                    for (var i = 0, length = values.length; i < length; i += 1) {
                        groupingTitle = values[i] && values[i].groupingTitle;
                        if (groupingTitle) {
                            // Create title only when we switch from one country group to another
                            if (groupingTitle !== tempGroupingTitle) {
                                // Create the grouping title for products, example. DHL, Express ...
                                html += '<p style="color: #656565; padding: 8px 8px 4px 2px; font-weight: bold; margin: 0 8px 0 8px; border-bottom: 1px solid rgba(34,36,38,.15);">' + groupingTitle + '</p>';
                            }

                            tempGroupingTitle = groupingTitle;
                            html += '<div style ="padding-left: 12px;" class="x-boundlist-item">' + values[i].countryname + '</div>';
                        }
                    }

                    // To make sure that the memory will be deallocate
                    // (EXT JS has shown some weird behaviors with templates and memory issues)
                    values = null;

                    return html;
                },
            });

        return template;
    },

    /**
     * Extract DHL GKP username and password from the form for a particular shop.
     *
     * @param { int } shopId It is needed because of the weird ShippingCommon items naming.
     * @return { { username: string, password: string } }
     */
    getCredentials: function (shopId) {
        var form = this.getForm();
        var usernameFieldName = this.makeShopQualifiedFieldName(shopId, 'username');
        var passwordFieldName = this.makeShopQualifiedFieldName(shopId, 'password');
        var useTestingWebserviceFieldName = this.makeShopQualifiedFieldName(shopId, 'useTestingWebservice');

        return {
            username: form.findField(usernameFieldName).getValue(),
            password: form.findField(passwordFieldName).getValue(),
            useTestingWebservice: form.findField(useTestingWebserviceFieldName).getValue(),
        };
    },

    /**
     * @param { int } shopId It is needed because of the weird ShippingCommon items naming.
     * @return { Ext.field.Text }
     */
    getUsernameField: function (shopId) {
        var ekpFieldName = this.makeShopQualifiedFieldName(shopId, 'username');

        return this.getForm().findField(ekpFieldName);
    },

    /**
     * @param { int } shopId It is needed because of the weird ShippingCommon items naming.
     * @return { Ext.field.Text }
     */
    getPasswordField: function (shopId) {
        var ekpFieldName = this.makeShopQualifiedFieldName(shopId, 'password');

        return this.getForm().findField(ekpFieldName);
    },

    /**
     * @param { int } shopId It is needed because of the weird ShippingCommon items naming.
     * @return { Ext.field.Text }
     */
    getEKPField: function (shopId) {
        var ekpFieldName = this.makeShopQualifiedFieldName(shopId, 'EKP');

        return this.getForm().findField(ekpFieldName);
    },

    /**
     * Get a field that lives in the same subshop fieldset as eventTarget and has the given origName attribute.
     *
     * @param { object } eventTarget some control
     * @param { string } origName
     * @return { object }
     */
    getFormFieldOfSubShop: function (shopId, origName) {
        var fieldName = this.makeShopQualifiedFieldName(shopId, origName);

        return this.getForm().findField(fieldName);
    },

    /**
     * Retoure countries used inside the order view
     *
     * Defined: The '$retoureCountries' is coming from viewParams() inside backend order Controller
     *
     * Note: The retoureCountries are defined at the end of the class because syntax's highlighting is seeing this
     *       as a JS error and so all the editor file is red
     */
    retoureCountries: Ext.JSON.decode('{$retoureCountries|@json_encode}') || [],

});
