// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The main controller of the DHL Adapter's daily closing subapp.
 * It contains only one form having a combobox for the shop selection,
 * two date fields as well as a toolbar with a 'cancel' and a 'submit' button.
 */
// {namespace name="backend/viison_dhl_daily_closing/main"}
Ext.define('Shopware.apps.ViisonDHLDailyClosing.view.main.Window', {

    extend: 'Shopware.apps.ViisonShippingCommonDailyClosing.view.main.Window',

    alias: 'widget.viison_dhl_daily_closing-main_window',

    /**
     * Plugin-specific properties required by the parent class
     */
    customSnippets: {
        title: '{s name="window/title"}{/s}',
        description: '{s name="window/description"}{/s}',
    },

    pluginSupportsAllShops: false,

    pluginSupportsDateRange: false,

});
