// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

// {namespace name=backend/viison_dhl_free_form_labels/main}
Ext.define('Shopware.apps.ViisonDHLFreeFormLabels.controller.Main', {

    extend: 'Shopware.apps.ViisonShippingCommonFreeFormLabels.controller.Main',

    /**
     * Plugin-specific properties required by the parent class
     */
    dispatchServiceProviderPanelClass: 'viison-dhl-free-form-labels-window',
    productStoreClass: 'Shopware.apps.ViisonDHLShipping.store.Product',
    labelConfirmPanelClass: 'Shopware.apps.ViisonDHLFreeFormLabels.view.LabelConfirm',
    labelConfirmWindow: 'Shopware.apps.ViisonDHLOrder.view.detail.LabelConfirmWindow', // Note: because we added a new store we need to override the default LabelConfirmWindow used in onShowLabelConfirm
    shippingLabelClass: 'Shopware.apps.ViisonDHLOrder.model.ShippingLabel',
    dispatchServiceProviderLabelConfirmPanel: 'order-viison-dhl-label-confirm-panel',
    labelPanelSelector: 'viison-dhl-free-form-labels-window',
    sendMailURL: '{url controller="ViisonDHLOrder" action="sendMail"}',
    downloadDocumentsURL: '{url controller="ViisonDHLOrder" action="downloadDocuments"}',
    listDispatchActionsControllerClass: 'Shopware.apps.ViisonDHLOrder.controller.ListDispatchActions',
    orderConfigDataClass: 'Shopware.apps.ViisonDHLOrder.store.OrderConfigData', // Note: we need also to Include this class in Free Form Labels workflow TODO we need to create a base view for order and free form labels flow (with the next bigger change in ShippingCommon)

});
