// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * Model handling the mapping of the fields from MOB Packstation Plugin.
 */
// {namespace name="backend/viison_dhl_order/dhl_packing_station"}
Ext.define('Shopware.apps.ViisonDHLOrder.model.DHLPackingStation', {

    /**
     * Extend from the standard ExtJS model.
     */
    extend: 'Ext.data.Model',

    /**
     * Fields to map.
     */
    fields: [
        { name: 'id', type: 'int' },
        { name: 'preferredLocation', type: 'string', default: '' },
        { name: 'preferredNeighborName', type: 'string', default: '' },
        { name: 'preferredNeighborAddress', type: 'string', default: '' },
        { name: 'preferredDay', type: 'string', default: '' },
    ],

});
