// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The model representing a single ShippingLabel as well as additional information
 * used to create one. This is necessary, because its not possible to add custom
 * parameters to a save() call.
 */
Ext.define('Shopware.apps.ViisonDHLOrder.model.ShippingLabel', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Shopware.apps.ViisonShippingCommonOrder.model.ShippingLabel',

    createURL: '{url controller="ViisonDHLOrder" action="createLabel"}',
    destroyURL: '{url controller="ViisonDHLOrder" action="destroyLabel"}',

    /**
     * New plugin-specific fields.
     */
    fields: [
        { name: 'settingsMinimumAge', type: 'int', useNull: true },
        { name: 'settingsPersonalHandover', type: 'boolean', defaultValue: false },
        { name: 'settingsSaturdayDelivery', type: 'boolean', defaultValue: false },
        { name: 'settingsParcelOutletRouting', type: 'boolean', defaultValue: false },
        { name: 'settingsIdentCheckAge', type: 'int', useNull: true },
        { name: 'settingsPostalDeliveryDutyPaid', type: 'boolean', defaultValue: false },
        { name: 'settingsClosestDroppointDelivery', type: 'boolean', defaultValue: false },
        { name: 'settingsSignedForByRecipient', type: 'boolean', defaultValue: false },
        // Extra settings
        { name: 'extraSettingsDayOfDelivery', type: 'string', defaultValue: '' },
        { name: 'extraSettingsPreferredDayOfDelivery', type: 'string', defaultValue: '' },
        { name: 'extraSettingsPreferredLocation', type: 'string', defaultValue: '' },
        { name: 'extraSettingsPreferredNeighbour', type: 'string', defaultValue: '' },
        { name: 'extraSettingsNoNeighbourDelivery', type: 'boolean', defaultValue: false },
        { name: 'extraSettingsItemName', type: 'string', defaultValue: '' },
        { name: 'extraSettingsIgnorePrintOnlyIfCodeablePreset', type: 'boolean', defaultValue: false },
        { name: 'extraSettingsInsuredValue', type: 'string', defaultValue: '' },
        { name: 'extraSettingsInsuredValueCurrency', type: 'string', defaultValue: '' },
        { name: 'extraSettingsIncoterm', type: 'string', defaultValue: '' },
        { name: 'extraSettingsFrankatur', type: 'string', defaultValue: '' },
        { name: 'extraSettingsAddresseesCustomsReference', type: 'string', defaultValue: '' },
        { name: 'extraSettingsEndorsementType', type: 'string', defaultValue: '' },
    ],

});
