// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The store handling the data from MOB Packstation Plugin.
 */
// {namespace name="backend/viison_dhl_order/dhl_packing_station"}
Ext.define('Shopware.apps.ViisonDHLOrder.store.DHLPackingStation', {

    /**
     * Extend from the standard ExtJS store.
     */
    extend: 'Ext.data.Store',

    /**
     * The id used to find the store in the application.
     */
    storeId: 'viisonDHLPackingStationStore',

    /**
     * Disable auto loading.
     */
    autoLoad: false,

    /**
     * Define the used model for this store.
     */
    model: 'Shopware.apps.ViisonDHLOrder.model.DHLPackingStation',

    /**
     * Define proxy
     */
    proxy: {
        type: 'ajax',
        api: {
            read: '{url controller="ViisonDHLOrder" action="getMOBPackingStationData"}',
        },
        reader: {
            type: 'json',
            root: 'data',
        },
    },

});
