// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 *  @Override
 */
// {namespace name="backend/viison_dhl_order/order"}
Ext.define('Shopware.apps.ViisonDHLOrder.view.detail.LabelConfirmWindow', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Shopware.apps.ViisonShippingCommonOrder.view.detail.LabelConfirmWindow',

    /**
     * List of short aliases for class names. Most useful for defining xtypes for widgets.
     */
    alias: 'widget.order-viison-dhl-label-confirm-window',

    /**
     * An optional extra CSS class that will be added to this component's Element.
     */
    cls: Ext.baseCSSPrefix + 'order-viison-dhl-label-confirm-window',

    /**
     * Reposition window to always be in center
     */
    listeners: {
        afterlayout: function () {
            this.center();
        },
    },

    /**
     * Mixins, so we can call parent/extend class methods
     */
    mixins: {
        labelConfirmWindow: 'Shopware.apps.ViisonShippingCommonOrder.view.detail.LabelConfirmWindow',
    },

    // @Override
    createDataPanel: function () {
        var me = this;

        // Add a new store to the order view for delivery time frame
        me.dataPanel = Ext.create(me.labelConfirmPanelClass, {
            record: me.record,
            store: me.store,
            maxNumberOfLabels: me.maxNumberOfLabels,
            dispatchServiceProviderTab: me.dispatchServiceProviderTab,
            productStore: me.productStore,
            shopStore: Ext.data.StoreManager.lookup('base.ShopLanguage').load(),
            countriesStore: me.subApp.getController('Main').countriesStore,
            isReturn: me.isReturn,
            orderConfigData: me.orderConfigData,
        });

        return me.dataPanel;
    },
});
