// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * This implementation of the order backend details window adds a additional
 * DHL tab to the end of the tab panel.
 */
Ext.define('Shopware.apps.ViisonDHLOrder.view.detail.Window', {

    /**
     * Override the default order details window or at least parts of it.
     */
    override: 'Shopware.apps.Order.view.detail.Window',

    /**
     * Register a plugin specific tab that is to be added to the order detail window. The tab is later
     * added to the window by generalized code implemented in the ShippingCommon module.
     */
    initComponent: function () {
        this.addDispatchServiceProviderTab({
            dispatchServiceProviderPanelClass: 'Shopware.apps.ViisonDHLOrder.view.detail.Tab',
            shippingLabelStoreClass: 'Shopware.apps.ViisonDHLOrder.store.ShippingLabel',
        });
        this.callParent(arguments);
    },

});
