// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * By overriding the default form, the CRUD methods for the DHL mapping are added
 * to the default save button event.
 */
// {namespace name="backend/viison_dhl_shipping/shipping"}
Ext.define('Shopware.apps.ViisonDHLShipping.controller.DefaultForm', {

    /**
     * Override the default shipping DefaultForm controller or at least parts of it.
     */
    override: 'Shopware.apps.Shipping.controller.DefaultForm',

    init: function () {
        this.callParent(arguments);
        this.addDispatchServiceProviderControllerClass('Shopware.apps.ViisonDHLShipping.controller.Tab');
    },

});
