// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * By overriding the default form, the CRUD methods for the DHL mapping are added
 * to the default save button event.
 */
// {namespace name="backend/viison_dhl_shipping/shipping"}
Ext.define('Shopware.apps.ViisonDHLShipping.controller.Tab', {

    /**
     * Extend the shipping tab controller from the ShippingCommon module
     */
    extend: 'Shopware.apps.ViisonShippingCommonShipping.controller.Tab',

    /**
     * Plugin-specific properties required by the parent class
     */
    tabAlias: 'shipping-viison-dhl-tab',
    productStoreClass: 'Shopware.apps.ViisonDHLShipping.store.Product',
    productMappingStoreClass: 'Shopware.apps.ViisonDHLShipping.store.ProductMapping',
    productMappingModelClass: 'Shopware.apps.ViisonDHLShipping.model.ProductMapping',
    dispatchServiceProviderName: 'DHL',

    /**
     * @Override
     * @returns Ext.Store
     */
    getProductStore: function () {
        return Ext.create(this.productStoreClass).load({
            params: {
                shopId: null,
                allProducts: true, // So we get all DHL Products, not just country specific
            },
        });
    },

});
