// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * @Extend
 */
Ext.define('Shopware.apps.ViisonDHLShipping.model.Product', {

    /**
     * Extend the Product model from the ShippingCommon module.
     */
    extend: 'Shopware.apps.ViisonShippingCommonShipping.model.Product',

    /**
     * New plugin-specific fields.
     */
    fields: [
        /** DHL Specific fields * */
        // This fields are used if grouByCountry is activated in params
        { name: 'country', type: 'string' },
        { name: 'products', type: 'auto' },

        // The code used to identify the product by DHL example: V06PAK
        { name: 'product', type: 'string' },
        { name: 'displayCountryName', type: 'string' },
        { name: 'availableInCountriesIso', type: 'string' },
    ],

});
