// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonDHLShipping.model.ProductMapping', {

    /**
     * Extend the ProductMapping model from the ShippingCommon module.
     */
    extend: 'Shopware.apps.ViisonShippingCommonShipping.model.ProductMapping',

    createURL: '{url controller="ViisonDHLShipping" action="createDispatchMapping"}',
    updateURL: '{url controller="ViisonDHLShipping" action="updateDispatchMapping"}',
    destroyURL: '{url controller="ViisonDHLShipping" action="destroyDispatchMapping"}',

    /**
     * New plugin-specific fields.
     */
    fields: [
        { name: 'visualAgeCheck', type: 'int', useNull: true },
        { name: 'personalHandover', type: 'boolean', defaultValue: false },
        { name: 'incoterm', type: 'string', defaultValue: '' },
        { name: 'frankatur', type: 'string', defaultValue: '' },
        { name: 'isSaturdayDelivery', type: 'boolean', defaultValue: false },
        { name: 'isInsured', type: 'boolean', defaultValue: false },
        { name: 'parcelOutletRouting', type: 'boolean', defaultValue: false },
        { name: 'endorsementType', type: 'string', defaultValue: '' },
        { name: 'identCheckAge', type: 'int', useNull: true },
        { name: 'postalDeliveryDutyPaid', type: 'boolean', defaultValue: false },
        { name: 'closestDroppointDelivery', type: 'boolean', defaultValue: false },
        { name: 'signedForByRecipient', type: 'boolean', defaultValue: false },
    ],

});
