// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * By overriding the default edit panel, the additional DHL tab is created
 * and added to the main tab panel.
 */
Ext.define('Shopware.apps.ViisonDHLShipping.view.edit.Panel', {

    /**
     * Override the default shipping edit panel or at least parts of it.
     */
    override: 'Shopware.apps.Shipping.view.edit.Panel',

    /**
     * Register a plugin specific tab that is to be added to the shipping edit panel. The tab is later
     * added to the panel by generalized code implemented in the ShippingCommon module.
     */
    initComponent: function () {
        this.addDispatchServiceProviderTabClass('Shopware.apps.ViisonDHLShipping.view.edit.Tab');
        this.callParent(arguments);
    },

});
