// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

// {namespace name="backend/viison_shipping_common_shipping/shipping"}
Ext.define('Shopware.apps.ViisonDHLShipping.view.edit.Tab', {
    extend: 'Shopware.apps.ViisonShippingCommonShipping.view.edit.Tab',
    xtype: 'shipping-viison-dhl-tab',
    productStoreId: 'viison-dhl-product-store',
    productMappingStoreClass: 'Shopware.apps.ViisonDHLShipping.store.ProductMapping',
    mappingPanelClass: 'Shopware.apps.ViisonDHLShipping.view.edit.MappingPanel',
    dispatchServiceProviderName: 'DHL',
    exportDocumentEnabled: true,

    /**
     * @Override
     */
    getAdditionalPropertiesForMappingForm: function () {
        return {
            countriesStore: (Ext.getStore('base.Country') || Ext.create('Shopware.apps.Base.store.Country')).load(),
        };
    },

});
