<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes;

use \Doctrine\Common\Collections\ArrayCollection;
use \Shopware\Plugins\ViisonCommon\Commands\PluginConfigTranslationsExportIniCommand;
use \Shopware\Plugins\ViisonCommon\Commands\PluginConfigImport;

class CliCommands
{
    /**
     * Returns an ArrayCollection with all the ViisonCommon cli commands, to be registered, as well
     * as their corresponding command implementations.
     *
     * @return ArrayCollection
     */
    public static function getCliCommands()
    {
        return new ArrayCollection([
            new PluginConfigTranslationsExportIniCommand(),
            new PluginConfigImport(),
        ]);
    }
}
