<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Document\RenderingContext;

use Shopware\Plugins\ViisonCommon\Classes\Document\PaperLayout;
use Shopware\Plugins\ViisonCommon\Classes\Document\RenderingEngine\RenderingEngine;

/**
 * RenderingContext to render a smarty template given by its path.
 */
class HtmlRenderingContext extends AbstractRenderingContext
{
    /**
     * @var string
     */
    private $html;

    /**
     * @param RenderingEngine $renderingEngine
     * @param PaperLayout $paperLayout
     * @param string $html
     */
    public function __construct(RenderingEngine $renderingEngine, PaperLayout $paperLayout, $html)
    {
        parent::__construct($renderingEngine, $paperLayout);
        $this->html = $html;
    }

    /**
     * @inheritdoc
     */
    protected function generateHtml()
    {
        return $this->html;
    }
}
