<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Exceptions\Plugins\SwagImportExport;

use Exception;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;

class ImportExportException extends Exception implements LocalizableThrowable
{
    use MessageLocalization;

    /**
     * @param string $message
     * @param string $snippetName
     * @param array $snippetArguments
     */
    public function __construct($message, $snippetName, array $snippetArguments = [])
    {
        $this->snippetName = $snippetName;
        $this->snippetNamespace  = 'exceptions/viison_common/plugins/swag_import_export/import_export_exception';
        $this->snippetArguments = $snippetArguments;

        parent::__construct(vsprintf($message, $snippetArguments));
    }

    /**
     * @deprecated This exception is not used anymore.
     *
     * @param string $adapterType
     * @return self
     */
    public static function unknownDbAdapterType($adapterType)
    {
        return new self(
            'The import/export DB adapter of type "%s" does not exist.',
            'unknown_db_adapter_type',
            [
                $adapterType,
            ]
        );
    }
}
