<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Exceptions\ValidationExceptions;

use Exception;

class AttributeNotFoundException extends AbstractValidationException
{
    /**
     * @param string $parameterName
     * @param string $modelClassName
     * @param int $entityId
     * @param Exception|null $previousException
     */
    public function __construct($parameterName, $modelClassName, $entityId, Exception $previousException = null)
    {
        $message = sprintf(
            'Entity of class "%s" given by ID=%d of parameter "%s" has no attribute row.',
            $modelClassName,
            $entityId,
            $parameterName
        );

        parent::__construct(
            $message,
            'attributeNotFoundException',
            [
                $modelClassName,
                $entityId,
                $parameterName,
            ],
            $previousException
        );
    }
}
