<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Plugins\SwagImportExport;

use Shopware\Components\SwagImportExport\DbAdapters\DataDbAdapter;

/**
 * DbAdapter adapter for SwagImportExport Version 2.x
 */
class SwagImportExportVersion2DbAdapterAdapter implements DataDbAdapter
{
    /**
     * @var AbstractDbAdapter $adapter
     */
    private $adapter;

    public function __construct(AbstractDbAdapter $adapter)
    {
        $this->adapter = $adapter;
    }

    public function read($ids, $columns)
    {
        return $this->adapter->read($ids, $columns);
    }

    public function readRecordIds($start, $limit, $filter)
    {
        return $this->adapter->readRecordIds($start, $limit, $filter);
    }

    public function getDefaultColumns()
    {
        return $this->adapter->getDefaultColumns();
    }

    public function getSections()
    {
        return $this->adapter->getSections();
    }

    public function getColumns($section)
    {
        return $this->adapter->getColumns($section);
    }

    public function write($records)
    {
        $this->adapter->write($records);
    }

    public function getUnprocessedData()
    {
        return $this->adapter->getUnprocessedData();
    }

    public function getLogMessages()
    {
        return $this->adapter->getLogMessages();
    }

    public function getLogState()
    {
        return $this->adapter->getLogState();
    }
}
