<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Plugins\SwagImportExport;

use SwagImportExport\Components\DbAdapters\DataDbAdapter;

/**
 * @Shopware\noEncryption
 * DbAdapter adapter for SwagImportExport Version 3.x
 */
class SwagImportExportVersion3DbAdapterAdapter implements DataDbAdapter
{
    /**
     * @var AbstractDbAdapter $adapter
     */
    private $adapter;

    /**
     * @var string $adapterName
     */
    private $adapterName;

    public function __construct(AbstractDbAdapter $adapter)
    {
        $this->adapter = $adapter;
        $this->adapterName = '';
    }

    public function supports(string $adapter): bool
    {
        return $adapter === $this->adapterName;
    }

    public function getUnprocessedData()
    {
        return $this->adapter->getUnprocessedData();
    }

    public function read(array $ids, array $columns): array
    {
        return $this->adapter->read($ids, $columns);
    }

    public function readRecordIds(?int $start, ?int $limit, array $filter = []): array
    {
        return $this->adapter->readRecordIds($start, $limit, $filter);
    }

    public function getDefaultColumns(): array
    {
        return $this->adapter->getDefaultColumns();
    }

    public function getSections(): array
    {
        return $this->adapter->getSections();
    }

    public function getColumns(string $section): array
    {
        return $this->adapter->getColumns($section);
    }

    public function write(array $records): void
    {
        $this->adapter->write($records);
    }

    public function getLogMessages(): array
    {
        return $this->adapter->getLogMessages();
    }

    public function getLogState(): ?string
    {
        return $this->adapter->getLogState();
    }
}
