<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes;

use Shopware\Plugins\ViisonCommon\Subscribers;

/**
 * Use this registrator just before registering your subscribers in the plugin bootstrap:
 *
 *  $viisonCommonSubscriberRegistrator = new Shopware\Plugins\ViisonCommon\Classes\SubscriberRegistrator($this);
 *  $viisonCommonSubscriberRegistrator->registerSubscribers();
 */
class SubscriberRegistrator extends AbstractSubscriberRegistrator
{
    /**
     * @inheritdoc
     */
    protected function createSubscribers()
    {
        // Determine the path of the loaded ViisonCommon instance
        $viisonCommonPath = realpath(__DIR__ . '/../');

        return [
            new Subscribers\Api\Error($this->pluginBootstrap),
            new Subscribers\Api\RestApiVariantUpdateSubscriber($this->pluginBootstrap),
            new Subscribers\Common($viisonCommonPath),
            new Subscribers\Components\DocumentComponentDummySubscriber(),
            new Subscribers\Components\TemplateMailComponentSubscriber($this->pluginBootstrap),
            new Subscribers\Controller\Frontend\FrontendErrorControllerSubscriber($this->pluginBootstrap),
            new Subscribers\ServiceDecorationSubscriber($this->pluginBootstrap),
            new Subscribers\Services($this->pluginBootstrap),
            new Subscribers\SmartyPluginRegistration($this->pluginBootstrap),
            new Subscribers\SubApplicationRegistrationSubscriber($this->pluginBootstrap),
        ];
    }
}
