<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components;

use \Shopware_Components_Document as DocumentComponent;
use Shopware\Models\Document\Document as DocumentModel;
use Shopware\Models\Shop\Locale;
use Shopware\Plugins\ViisonCommon\Classes\Util\Document as DocumentUtil;

/**
 * @deprecated No actual replacement. Consider using
 *     {@see \Shopware\Plugins\ViisonCommon\Components\DocumentRenderingContextFactoryService} as a possible
 *     alternative.
 */
class Document extends DocumentComponent
{
    /**
     * Initializes a DocumentComponent, similar to \Shopware_Components_Document
     *
     * @param DocumentModel $documentTemplate
     * @param Locale $locale
     * @param array $vars
     * @param null|int $orderId (optional, link document to a specific order)
     * @return DocumentComponent.
     */
    public static function initDocument(
        DocumentModel $documentTemplate,
        Locale $locale,
        array $vars,
        $orderId = null
    ) {
        $document = parent::initDocument($orderId, $documentTemplate->getId(), [
            '_renderer' => 'pdf',
            '_previewSample' => 1,
        ]);

        // Change the document language to the given locale
        DocumentUtil::changeDocumentLanguage($document, $locale);

        // Assign values and override with given values
        $document->assignValues();
        $document->_view->assign($vars);

        // Build the theme inheritance of the default shop, or respective shop of the order (if given)
        if ($orderId) {
            $document->_subshop = Shopware()->Container()->get('models')->find('Shopware\\Models\\Order\\Order', $orderId)->getShop();
        } else {
            $document->_subshop = Shopware()->Container()->get('models')->getRepository('Shopware\\Models\\Shop\\Shop')->getActiveDefault();
        }

        return $document;
    }

    /**
     * Renders a given document. If the document is connected to a certain Order (orderId was set upon initialization),
     * the document is already connected to this Order and created as an Order\Document\Document. Therefore we have
     * to save the pdf (as a file) to make it available in the backend.
     *
     * @param DocumentComponent $document
     * @return mPDF|string
     * @throws \Exception
     * @throws \SmartyException
     */
    public static function renderDocument($document)
    {
        $template = $document->_subshop->getDocumentTemplate() ? $document->_subshop->getDocumentTemplate() : $document->_subshop->getMain()->getDocumentTemplate();
        $inheritance = Shopware()->Container()->get('theme_inheritance')->getTemplateDirectories($template);
        $document->_template->setTemplateDir($inheritance);

        // Return early and show only data, if html renderer was set
        $html = $document->_template->fetch('documents/' . $document->_document['template'], $document->_view);

        $mpdf = new \mPDF('utf-8', 'A4', '', '', $document->_document['left'], $document->_document['right'], $document->_document['top'], $document->_document['bottom']);
        $mpdf->WriteHTML($html);

        /**
         * If we set an orderId, therefore an $order and !$preview, an actual pdf is created and connected to the order.
         * In this case we have to save the pdf file, so the pdf can be accessed through the order in the shop backend.
         */
        if (!$document->_preview && $document->_documentHash) {
            $path = Shopware()->Container()->getParameter('kernel.root_dir') . '/files/documents/' . $document->_documentHash . '.pdf';
            $mpdf->Output($path, 'F');
        }

        // Otherwise the document is not connected to any order: just return the mPDF object
        return $mpdf;
    }
}
