<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components\Migration;

/**
 * A localized message that will be displayed to the user after the migration.
 */
class MigrationMessage
{
    /**
     * @var string
     */
    private $snippetName;

    /**
     * @var string
     */
    private $snippetNamespace;

    /**
     * @var mixed[]
     */
    private $snippetArguments;

    /**
     * @param string $snippetName
     * @param string $snippetNamespace
     * @param array $snippetArguments
     */
    public function __construct($snippetName = null, $snippetNamespace = null, array $snippetArguments = [])
    {
        $this->snippetName = $snippetName;
        $this->snippetNamespace = $snippetNamespace;
        $this->snippetArguments = $snippetArguments;
    }

    /**
     * @param \Enlight_Components_Snippet_Manager $snippetManager
     * @return string The localized message as translated using $snippetManager
     */
    public function localize(\Enlight_Components_Snippet_Manager $snippetManager)
    {
        $snippet = $snippetManager->getNamespace($this->snippetNamespace)->get($this->snippetName);

        if ($snippet === null) {
            return sprintf('### Missing snippet %s/%s ###', $this->snippetNamespace, $this->snippetName);
        }

        return vsprintf($snippet, $this->snippetArguments);
    }
}
