<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components\SubApplicationLoading\SubApplicationBuilder;

abstract class AbstractSubApplicationBuilder implements SubApplicationBuilder
{
    /**
     * @var string Path to the plugin of the SubApplication to build
     */
    protected $pluginPath;

    /**
     * @var string Fully namespaced class name of the controller class to retrieve the view-params from
     */
    protected $controllerClassName;

    /**
     * @var string Name of the SubApplication to build
     */
    protected $name;

    /**
     * @param string $name Name of the SubApplication to build
     * @param string $pluginPath Path to the plugin of the SubApplication
     */
    public function __construct($name, $pluginPath)
    {
        $this->name = $name;
        $this->pluginPath = $pluginPath;
        $this->controllerClassName = 'Shopware_Controllers_Backend_' . $name;
    }

    /**
     * @inheritdoc
     */
    public function getSubApplicationName()
    {
        return $this->name;
    }

    /**
     * Use another controller class for this SubApplication instead of the default one to retrieve view-params from.
     *
     * The {$nonDefaultControllerClass}::getViewParams() is used to retrieve the view-params for the JS code rendering.
     * E.g. if that SubApplication is just meant as a depending component for other SubApplications. The default is:
     * `\Shopware_Controllers_Backend_[NameOfSubApplication]`
     *
     * @param string $controllerClassName Fully namespaced class name of the controller class
     * @return self
     */
    public function usingCustomControllerClass($controllerClassName)
    {
        $this->controllerClassName = $controllerClassName;

        return $this;
    }
}
