<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Plugins\ViisonCommon\Classes\Util\Currency as CurrencyUtil;
use Shopware\Plugins\ViisonCommon\Controllers\ViisonCommonBaseController;

class Shopware_Controllers_Backend_ViisonCommonCurrencyFormatter extends ViisonCommonBaseController
{
    /**
     * @inheritdoc
     */
    public function getViewParams()
    {
        // Get the default currency's sign info
        $defaultCurrency = CurrencyUtil::getDefaultCurrency();

        $currencySymbol = html_entity_decode($defaultCurrency->getSymbol(), ENT_COMPAT | ENT_HTML5, 'UTF-8');

        return [
            'currencySymbol' => $currencySymbol,
            'symbolAtEnd' => $defaultCurrency->getSymbolPosition() !== 32,
        ];
    }
}
