<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use \Shopware\Plugins\ViisonCommon\Classes\CliCommands;

if (!class_exists('ViisonCommon_Plugin_BootstrapV5')) {
    require_once('PluginBootstrapV5.php');
}

/**
 * Version 6 of the common plugin Bootstrap class. This version is based on ViisonCommon_Plugin_BootstrapV5 and provides
 * an extra method to register commands from viison common.
 *
 * This class needs to be manually loaded in the plugin:
 *
 * if (!class_exists('ViisonCommon_Plugin_BootstrapV6')) {
 *     require_once('ViisonCommon/PluginBootstrapV6.php');
 * }
 */
class ViisonCommon_Plugin_BootstrapV6 extends ViisonCommon_Plugin_BootstrapV5
{
    /**
     * Subscribes to the Shopware_Console_Add_Command Event
     */
    public function update($version)
    {
        parent::update($version);

        $this->subscribeEvent('Shopware_Console_Add_Command', 'addViisonCommonConsoleCommands');
    }

    /**
     * Adds all Viison Common commands
     *
     * @param \Enlight_Event_EventArgs $args
     * @return \Doctrine\Common\Collections\ArrayCollection
     */
    public function addViisonCommonConsoleCommands(\Enlight_Event_EventArgs $args)
    {
        return CliCommands::getCliCommands();
    }
}
