<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Subscribers;

use Shopware\Plugins\ViisonCommon\Subscriber\Common as LegacyCommonSubscriber;

/**
 * For now this is just a proxy of the deprecated subscriber class
 * Shopware\Plugins\ViisonCommon\Subscriber\Common. Usually we would move all functionality
 * from deprecated classes to the new class and and let the old class function as a proxy.
 * However, since old versions of ViisonCommon_Plugin_Bootstrap compare the already registered
 * subscribers to the old Subscriber class before registerting their common subscriber, the
 * check would fail if a new subscriber is already registered, which is not a proxy of the old
 * class. That is, it is safe to change the class the subscribers are compared to, to this class
 * since the already registered subscriber will always be of this class, as soon as a version
 * of ViisonCommon is available that contains this class.
 */
class Common extends LegacyCommonSubscriber
{
}
