<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Subscribers;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\AbstractBaseSubscriber;

class SmartyPluginRegistration extends AbstractBaseSubscriber
{
    /**
     * @return array
     */
    public static function getSubscribedEvents()
    {
        return [
            'Enlight_Controller_Front_DispatchLoopStartup' => 'addCustomSmartyFunctions',
        ];
    }

    /**
     * Adds our custom smarty plugin compiler class directory at the beginning of the plugins directory list.
     * This way our plugins are loaded (and therefore) used before Shopwares own plugins and we can overwrite any
     * smarty function with a custom compiler in our directory.
     *
     * @param \Enlight_Controller_EventArgs $args
     */
    public function addCustomSmartyFunctions(\Enlight_Controller_EventArgs $args)
    {
        $templateManager = $this->get('template');
        $templateDirs = $templateManager->getPluginsDir();
        $viisonCommonSmartyPluginDir = __DIR__ . '/../Classes/SmartyPlugins/';
        if (count($templateDirs) === 0 || (mb_stripos($templateDirs[0], 'ViisonCommon') === false)) {
            // Add our directory at the beginning
            array_unshift($templateDirs, $viisonCommonSmartyPluginDir);
            $templateManager->setPluginsDir($templateDirs);
        }
    }
}
