// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonHintPanel.view.hints.ShowHideGridColumnsHint', {

    extend: 'Shopware.apps.ViisonCommonHintPanel.view.Panel',
    alias: 'widget.viison_common_hint_panel-show_hide_grid_columns_hint',

    /**
     * @overwrite
     */
    initComponent: function () {
        this.hintText = this.getViisonSnippet('show_hide_grid_columns_hint/text');

        this.callParent(arguments);
    },

    /**
     * @overwrite
     */
    getItems: function () {
        var items = this.callParent(arguments);

        // Add an additional image next to the hint text. 'items[0]' is the container that contains the hint text
        items[0].items.splice(2, 0, {
            xtype: 'container',
            cls: 'is--hint-image--show-hide-grid-columns',
        });

        return items;
    },
});
