// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonHintPanel.view.Panel', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_common_hint_panel-panel',
    cls: 'viison_common_hint_panel-panel',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonConfigNamespace: 'ViisonCommonHintPanel',
    viisonSnippetNamespace: 'backend/viison_common_hint_panel/main',

    border: false,
    layout: {
        type: 'hbox',
        align: 'stretch',
    },

    // This id identifies the hint, so it can be disabled per subApp / window / panel
    hintId: '',

    // This text is shown as the main hint text after an image and the hint prefix
    hintText: '',

    // Set the border configuration according to the context where this hint is shown
    hasTopBorder: true,
    hasRightBorder: true,
    hasBottomBorder: true,
    hasLeftBorder: true,

    /**
     * @overwrite
     */
    initComponent: function () {
        // Check if the hin should be shown at all
        if (this.isHintHidden()) {
            this.setVisible(false);
        }

        // Add borders according to the configuration
        if (this.hasTopBorder) {
            this.addCls('has--top-border');
        }
        if (this.hasRightBorder) {
            this.addCls('has--right-border');
        }
        if (this.hasBottomBorder) {
            this.addCls('has--bottom-border');
        }
        if (this.hasLeftBorder) {
            this.addCls('has--left-border');
        }

        this.items = this.getItems();

        this.callParent(arguments);
    },

    getItems: function () {
        return [
            {
                xtype: 'container',
                cls: 'is--hint-container-inner',
                layout: {
                    type: 'hbox',
                    pack: 'start',
                },
                flex: 1,
                items: [
                    {
                        xtype: 'container',
                        cls: 'misc--help is--icon--lightbulb',
                    },
                    {
                        xtype: 'label',
                        cls: 'is--hint-text',
                        html: new Ext.XTemplate('<strong>{prefix}</strong>{hintText}').apply({
                            prefix: this.getViisonSnippet('hint/prefix'),
                            hintText: this.hintText,
                        }),
                    },
                ],
            },
            {
                xtype: 'container',
                layout: {
                    type: 'vbox',
                    align: 'top',
                    pack: 'top',
                },
                items: [
                    {
                        xtype: 'button',
                        cls: 'is--button-hide-hint',
                        listeners: {
                            scope: this,
                            render: function (container) {
                                container.el.on('click', function () {
                                    this.confirmHintHiding();
                                }, this);
                            },
                        },
                    },
                ],
            },
        ];
    },

    confirmHintHiding: function () {
        Ext.Msg.confirm(
            this.getViisonSnippet('confirm/title'),
            this.getViisonSnippet('confirm/text'),
            function (buttonId) {
                if (buttonId === 'yes') {
                    this.hideHintPermanently();
                }
                // Hide the button for now in any case, since the "X" button was clicked
                this.up('window').remove(this);
            },
            this
        );
    },

    /**
     * Returns true if the hint is hidden by the user.
     *
     * @returns boolean
     */
    isHintHidden: function () {
        // Remark: local storage only stores strings.
        return window.localStorage.getItem(this.getLocalStorageKey()) === 'true';
    },

    /**
     * Hides the hint permanently for the user by setting the corresponding local storage value.
     */
    hideHintPermanently: function () {
        return window.localStorage.setItem(this.getLocalStorageKey(), 'true');
    },

    /**
     * Returns an identifier string which is a combination of the currently logged in user id and the hint id of this
     * hint.
     *
     * @returns string
     */
    getLocalStorageKey: function () {
        var key = this.hintId + '-' + this.getViisonConfig('viisonCommonHintPanelUserId');

        return key.replace(' ', '');
    },
});
