// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonIndexPopup.controller.Main', {

    extend: 'Ext.app.Controller',
    mainWindow: null,

    /**
     * @Override
     */
    init: function () {
        // Create and setup window
        this.mainWindow = this.getView('Window').create();
        this.mainWindow.setTitle(this.subApplication.localizedName);
        if (typeof this.subApplication.params.windowWidth !== 'undefined') {
            this.mainWindow.setWidth(this.subApplication.params.windowWidth);
        }

        // Set either HTML or content URL
        if (typeof this.subApplication.params.html !== 'undefined') {
            this.mainWindow.setContentHTML(this.subApplication.params.html);
        } else if (typeof this.subApplication.params.contentURL !== 'undefined') {
            this.mainWindow.setContentURL(this.subApplication.params.contentURL);
        }

        if (typeof this.subApplication.params.saveURL !== 'undefined') {
            // Save the save URL
            this.saveURL = this.subApplication.params.saveURL;
        } else {
            // Hide the 'hide dialog in the future' checkbox
            this.mainWindow.hideDialogInTheFutureCheckbox.hide();
        }

        this.control({
            'viison_commmon_index_popup-window': {
                closeWindow: this.onCloseWindow,
            },
        });

        this.callParent(arguments);
    },

    /**
     * Sends the checked value of the 'hide dialog in the future' checkbox
     * to the server and closes the main window.
     */
    onCloseWindow: function () {
        if (typeof this.saveURL !== 'undefined') {
            // Save the user choice
            Ext.Ajax.request({
                url: this.saveURL,
                params: {
                    hideDialogInTheFuture: this.mainWindow.hideDialogInTheFutureCheckbox.checked,
                },
            });
        }

        this.mainWindow.close();
    },

});
