// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonMigration.model.MigrationExecutionResult', {
    extend: 'Ext.data.Model',

    fields: [
        { name: 'id', type: 'int' },
        { name: 'migrationTranscript', type: 'auto' },
    ],

    associations: [{
        type: 'hasMany',
        model: 'Shopware.apps.ViisonCommonMigration.model.MigrationSet',
        associationKey: 'migrationSets',
        name: 'getMigrationSets',
        foreignKey: 'migrationExecutionResultId',
        primaryKey: 'id',
    }],

    /**
     * @returns {string[]}
     */
    getInvalidatedCaches: function () {
        return this.get('migrationTranscript').invalidatedCaches;
    },

    /**
     * @returns {string[]}
     */
    getMessages: function () {
        return this.get('migrationTranscript').messages;
    },

    /**
     * @returns {boolean}
     */
    hasExecutableMigrations: function () {
        var migrationSets = this.getMigrationSets();
        for (var i = 0; i < migrationSets.count(); i += 1) {
            if (migrationSets.getAt(i).get('hasExecutableMigrations')) {
                return true;
            }
        }

        return false;
    },
});
