// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonMigration.view.error.Window', {
    extend: 'Enlight.app.Window',
    alias: 'widget.viison_common_migration-error_window',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_common_migration/main',

    autoShow: true,
    minimizable: false,
    layout: {
        type: 'vbox',
        align: 'stretch',
        pack: 'start',
    },
    height: '70%',
    width: 900,
    modal: true,

    migrationExecutionResult: null,

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('errorWindow/title');

        this.items = [
            this.createHelpContainer(),
            this.createMigrationsList(),
            this.createMigrationLogContainer(),
        ];

        this.buttons = this.createButtons();

        this.callParent(arguments);
    },

    /**
     * @returns {(Ext.button.Button)[]}
     */
    createButtons: function () {
        this.disablePluginsButton = Ext.create('Ext.button.Button', {
            text: this.getViisonSnippet('errorWindow/button/disablePlugins/text'),
            cls: 'secondary',
            handler: function () {
                Ext.Msg.confirm(
                    this.getViisonSnippet('errorWindow/button/disablePlugins/confirmation/title'),
                    this.getViisonSnippet('errorWindow/button/disablePlugins/confirmation/text'),
                    function (selection) {
                        if (selection === 'yes') {
                            this.fireEvent('clickDisablePluginsButton', this);
                        }
                    },
                    this
                );
            },
            scope: this,
        });

        this.reloadBackendButton = Ext.create('Ext.button.Button', {
            text: this.getViisonSnippet('errorWindow/button/reloadBackend/text'),
            cls: 'primary',
            hidden: true,
            handler: function () {
                this.fireEvent('clickReloadBackendButton', this);
            },
            scope: this,
        });

        this.retryButton = Ext.create('Ext.button.Button', {
            text: this.getViisonSnippet('errorWindow/button/retry/text'),
            cls: 'primary',
            handler: function () {
                this.fireEvent('retry', this);
            },
            scope: this,
        });

        return [
            this.disablePluginsButton,
            this.reloadBackendButton,
            this.retryButton,
        ];
    },

    /**
     * @returns {object}
     */
    createHelpContainer: function () {
        return {
            xtype: 'container',
            cls: 'viison-common--explanation-area',
            anchor: '100%',
            items: [
                {
                    xtype: 'container',
                    cls: 'is--header',
                    html: this.getViisonSnippet('errorWindow/description/header'),
                },
                {
                    xtype: 'container',
                    cls: 'is--paragraph',
                    html: this.getViisonSnippet('errorWindow/description/paragraph'),
                },
            ],
        };
    },

    /**
     * @returns {Shopware.apps.ViisonCommonMigration.view.error.List}
     */
    createMigrationsList: function () {
        this.migrationsList = Ext.create('Shopware.apps.ViisonCommonMigration.view.error.List', {
            store: this.migrationExecutionResult.getMigrationSets(),
            height: 100,
            anchor: '100%',
        });

        return this.migrationsList;
    },

    /**
     * @returns {object}
     */
    createMigrationLogContainer: function () {
        return {
            xtype: 'container',
            flex: 1,
            anchor: '100%',
            layout: 'border',
            items: [
                {
                    xtype: 'container',
                    region: 'north',
                    cls: 'viison-common--explanation-area',
                    items: [
                        {
                            xtype: 'container',
                            cls: 'is--header is--last',
                            html: this.getViisonSnippet('errorWindow/migrationSetList/header'),
                        },
                    ],
                },
                this.createMigrationLog(),
            ],
        };
    },

    /**
     * @returns {Shopware.apps.ViisonCommonMigration.component.MigrationLog}
     */
    createMigrationLog: function () {
        this.migrationLog = Ext.create('Shopware.apps.ViisonCommonMigration.component.MigrationLog', {
            region: 'center',
            migrationExecutionResult: this.migrationExecutionResult,
        });

        return this.migrationLog;
    },
});
