// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * A helper class to assert shopware versions in backend view applications.
 */
Ext.define('Shopware.apps.ViisonCommonShopwareVersion.Util', {

    singleton: true,
    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    alternateClassName: 'ViisonCommonShopwareVersionUtil',
    viisonConfigNamespace: 'ViisonCommonShopwareVersion',

    constructor: function () {
        this.shopwareVersion = this.getViisonConfig('shopwareVersion');
    },

    getShopwareVersion: function () {
        return this.shopwareVersion;
    },

    /**
     * Assert that the current shopware version is at least as high as the given shopware version. Uses the Ext.Version
     * component.
     *
     * @param string version
     * @return boolean
     */
    assertMinimumVersion: function (version) {
        if (this.shopwareVersion === '___VERSION___') {
            return true;
        }

        var actualVersion = new Ext.Version(this.shopwareVersion);
        var givenVersion = new Ext.Version(version);

        return actualVersion.isGreaterThanOrEqual(givenVersion);
    },

});
