<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Classes;

use Shopware\Plugins\ViisonShippingCommon\Structs\PageSize;
use \ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingDocumentType as ShippingDocumentTypeInterface;

class ShippingDocumentType implements ShippingDocumentTypeInterface
{
    /**
     * @var int
     */
    protected $id;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var PageSize
     */
    protected $pageSize;

    /**
     * @param int $id
     * @param string $name
     * @param PageSize $pageSize
     */
    public function __construct($id, $name, PageSize $pageSize)
    {
        $this->id = $id;
        $this->name = $name;
        $this->pageSize = $pageSize;
    }

    /**
     * @inheritdoc
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @inheritdoc
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @inheritdoc
     */
    public function getPageSizeName()
    {
        return $this->pageSize->name;
    }

    /**
     * @inheritdoc
     */
    public function getPageSizeWidth()
    {
        return $this->pageSize->width;
    }

    /**
     * @inheritdoc
     */
    public function getPageSizeHeight()
    {
        return $this->pageSize->height;
    }
}
