<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Classes;

use Shopware\Plugins\ViisonCommon\Components\FileStorage\FileStorage;
use Shopware\Plugins\ViisonShippingCommon\Util;

/**
 * Interface that can be used to create and delete labels. Needs to be implemented by all shipping plugins.
 *
 * @deprecated Should not be used by internal code any more, use Communication class instead.
 */
abstract class ShippingLabelGenerator
{

    public function __construct(Util $util, ShippingUtil $shippingUtil)
    {
        $this->util = $util;
        $this->pluginInfo = $util->getPluginInfo();
        $this->shippingUtil = $shippingUtil;
    }

    /**
     * @deprecated
     * Create a new shipping label for a given order.
     *
     * @param int $orderId The id of the order for which a label should be created.
     * @param float $weight The weight to use as the shipment's weight.
     * @param bool $useItemWeights A flag indicating whether to use the weight defined in each item or to calculate the item weights from the total weight. This parameter is only relevant for shipments containing an export document (e.g. Weltpaket).
     * @param array $shippingDetails An array containing the receivers address data.
     * @param array $packageDimensions An array containing the dimensions of the package, for which a new label shall be created.
     * @param array $settings An array containing the settings for the new label.
     * @param array $extraSettings An array containing plugin-specific settings
     * @param array $exportDocumentItems An array containing the order items and quantities, which will be contained in the shipment.
     * @return string The tracking code of the newly created label.
     */
    abstract public function createLabel($orderId, $weight, $useItemWeights, $shippingDetails, $packageDimensions, $settings, $extraSettings, $exportDocumentItems);

    /**
     * @deprecated
     * Create a new return label for a given order.
     *
     * @param int $orderId The id of the order for which a label should be created.
     * @param float $weight The weight to use as the shipment's weight.
     * @param array $shippingDetails
     * @param array|null $packageDimensions
     * @param array|null $settings
     * @param array $extraSettings An optional array containing plugin-specific settings
     * @return string The tracking code of the newly created label.
     */
    abstract public function createReturnLabel($orderId, $weight, $shippingDetails, $packageDimensions, $settings, $extraSettings);

    /**
     * @deprecated
     * Deletes the label with given tracking code.
     * @param string $trackingCode
     * @return void
     */
    abstract public function deleteLabel($trackingCode);

    /**
     * @deprecated
     * Deletes the return label with given tracking code.
     * @param string $trackingCode
     * @return void
     */
    abstract public function deleteReturnLabel($trackingCode);

    /**
     * @deprecated
     * Deletes the label with the given tracking code from the local database and the file system.
     *
     * @param string $trackingCode
     * @param string $documentIdentifier
     */
    public function deleteLabelLocally($trackingCode, $documentIdentifier)
    {
        // Delete tracking code from database
        $this->shippingUtil->deleteTrackingCode($trackingCode, $documentIdentifier);

        // Delete the possibly cached PDF files from disk
        /** @var FileStorage $fileStorageService */
        $fileStorageService = Shopware()->Container()->get('viison_common.document_file_storage_service');
        $labelFileName = $this->util->getDocumentFileName($documentIdentifier, ShippingUtil::DOCUMENT_TYPE_SHIPPING_LABEL);
        if ($fileStorageService->doesFileExist($labelFileName)) {
            // Delete the label file
            $fileStorageService->deleteFile($labelFileName);
        }
        $exportDocumentFileName = $this->util->getDocumentFileName($documentIdentifier, ShippingUtil::DOCUMENT_TYPE_EXPORT_DOCUMENT);
        if ($fileStorageService->doesFileExist($exportDocumentFileName)) {
            // Delete the export document file
            $fileStorageService->deleteFile($exportDocumentFileName);
        }
    }
}
