<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Classes;

/**
 * This is an implementation of the ShippingProduct interface defined in ViisonPickwareMobile
 * (and the legacy interface in ViisonPickwareConnector). It requires only a simple identifier
 * and a name to create an instance.
 */
class ShippingProduct implements
    \ViisonPickwareConnector_API_ShippingProduct,
    \ViisonPickwareMobile_Interfaces_ShippingProvider_ShippingProduct
{

    private $identifier;

    private $name;

    private $packageDimensionsRequired;

    private $availableOptions;

    private $defaultPackageDimensions;

    /**
     * @param $identifier
     * @param $name
     * @param bool $packageDimensionsRequired
     * @param array $availableOptions
     * @param array $defaultPackageDimensions
     */
    public function __construct($identifier, $name, $packageDimensionsRequired = false, array $availableOptions = array(), array $defaultPackageDimensions = null)
    {
        $this->identifier = $identifier;
        $this->name = $name;
        $this->packageDimensionsRequired = $packageDimensionsRequired;
        $this->availableOptions = $availableOptions;
        $this->defaultPackageDimensions = $defaultPackageDimensions;
    }

    /* Override */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /* Override */
    public function getName()
    {
        return $this->name;
    }

    /* Override */
    public function packageDimensionsRequired()
    {
        return $this->packageDimensionsRequired;
    }

    /* Override */
    public function getAvailableOptions()
    {
        return $this->availableOptions;
    }

    /**
     * @return array
     */
    public function getDefaultPackageDimensions()
    {
        return $this->defaultPackageDimensions;
    }
}
