<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Classes\Types;

/**
 * Class for storing package dimensions (weight and size)
 *
 * All values are stores in the base SI unit (meters and kilograms)
 */
class PackageDimension
{
    const MILLIMETERS = 0.001;
    const CENTIMETERS = 0.01;
    const DECIMETERS = 0.1;
    const METERS = 1;

    const KILOGRAMS = 1;
    const GRAMS = 0.001;

    /**
     * @var float|null Weight im kilograms
     */
    protected $weight;

    /**
     * @var float|null Height in Meters
     */
    protected $height;

    /**
     * @var float|null Width in Meters
     */
    protected $width;

    /**
     * @var float|null Length in Meters
     */
    protected $length;

    /**
     * @return float|null
     */
    public function getWeight($unit = self::KILOGRAMS)
    {
        return $this->weight / $unit;
    }

    /**
     * @param float|null $weight
     */
    public function setWeight($weight, $unit = self::KILOGRAMS)
    {
        $this->weight = $weight * $unit;
    }

    /**
     * @return float|null
     */
    public function getHeight($unit = self::METERS)
    {
        return $this->height / $unit;
    }

    /**
     * @param float|null $height
     */
    public function setHeight($height, $unit = self::METERS)
    {
        $this->height = $height * $unit;
    }

    /**
     * @return float|null
     */
    public function getWidth($unit = self::METERS)
    {
        return $this->width / $unit;
    }

    /**
     * @param float|null $width
     */
    public function setWidth($width, $unit = self::METERS)
    {
        $this->width = $width * $unit;
    }

    /**
     * @return float|null
     */
    public function getLength($unit = self::METERS)
    {
        return $this->length / $unit;
    }

    /**
     * @param float|null $length
     */
    public function setLength($length, $unit = self::METERS)
    {
        $this->length = $length * $unit;
    }
}
