<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Components\Logger;

/**
 * Class to log http request/responses
 *
 * You need to implement abstract functions for filtering sensitive data.
 *
 * @deprecated Use `Shopware\Plugins\ViisonShippingCommon\Components\Logger\AbstractHttpRequestLogger` instead.
 */
abstract class AbstractHttpLogger extends AbstractLogger
{
    /**
     * Logs the last request with level "debug"
     *
     * @param string $url
     * @param string $request
     * @param string $response
     */
    public function logSuccessfulRequest($url, $request, $response)
    {
        $this->logger->debug(
            sprintf('HTTP request to %s executed.', $url),
            [
                'url' => $url,
                'request' => $this->filterSensitiveDataIfNecessary($request),
                'response' => $this->filterSensitiveDataIfNecessary($response),
            ]
        );
    }

    /**
     * Logs a failed request with level "error"
     *
     * @param string $url
     * @param string $request
     */
    public function logFailedRequest($url, $request)
    {
        $this->logger->error(
            sprintf('HTTP request to %s failed.', $url),
            [
                'url' => $url,
                'request' => $this->filterSensitiveDataIfNecessary($request),
            ]
        );
    }

    /**
     * @param string $content
     * @return string
     */
    private function filterSensitiveDataIfNecessary($content)
    {
        if ($this->logSensitiveData) {
            return $content;
        }

        return $this->filterSensitiveData($content);
    }

    /**
     * Removes sensitive data from a request/response
     *
     * This should be login credentials or API keys
     *
     * @param string $content
     * @return string Filtered content
     */
    abstract public function filterSensitiveData($content);
}
