<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Components\Logger;

use Psr\Log\LoggerInterface;

abstract class AbstractLogger
{
    /**
     * @var LoggerInterface
     */
    protected $logger;

    /**
     * @var bool whether sensitive data should be logged or not
     */
    protected $logSensitiveData = false;

    /**
     * @param LoggerInterface $logger
     */
    public function __construct(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    /**
     * @return bool
     */
    public function logsSensitiveData()
    {
        return $this->logSensitiveData;
    }

    /**
     * @param bool $logSensitiveData
     */
    public function setLogSensitiveData($logSensitiveData)
    {
        $this->logSensitiveData = $logSensitiveData;
    }
}
