<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Components\ReturnLabelCreation;

interface ReturnLabelCreator
{
    /**
     * @param int $orderId
     * @param array $receiverAddress
     * @param float $weightInKg
     * @param array|null $configuration
     * @return array
     */
    public function createReturnLabel(
        $orderId,
        array $receiverAddress,
        $weightInKg,
        array $configuration = null
    );
}
