<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Controllers\Backend;

use Shopware\Plugins\ViisonCommon\Controllers\ViisonCommonBaseController;

/**
 * This controller adds some actions called in the free form labels backend controller.
 */
class ViisonShippingCommonFreeFormLabels extends ViisonCommonBaseController
{
    public function getCountriesAction()
    {
        $countries = Shopware()->Models()->getRepository('Shopware\Models\Country\Country')->getCountriesQuery()->getArrayResult();

        $this->View()->assign(array(
            'success' => true,
            'data' => $countries
        ));
    }
}
