<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Controllers\Backend;

use Shopware\Plugins\ViisonCommon\Controllers\ViisonCommonBaseController;

/**
 * This controller provides some backend action for adding an article variant
 * to the barcode label list as well as for displaying a PDF containing all barcode labels
 * generated from that list and listing all existing barcode labels.
 */
class ViisonShippingCommonGridLabelPrinting extends ViisonCommonBaseController
{

    protected $plugin;

    public function __construct(\Enlight_Controller_Request_Request $request = null, \Enlight_Controller_Response_Response $response = null, \Shopware_Components_Plugin_Bootstrap $plugin = null)
    {
        parent::__construct($request, $response);
        $this->plugin = $plugin;
    }

    /**
     * Sends a list with the names of all available grid label templates as the JSON response.
     */
    public function getGridLabelTemplateListAction()
    {
        $templates = $this->getGridLabelTemplates();

        $this->View()->assign(array(
            'success' => true,
            'data' => $templates,
            'total' => count($templates)
        ));
    }

    /**
     * Returns a list with the names of all available grid label templates.
     *
     * @return array
     */
    protected function getGridLabelTemplates()
    {
        $defaultLayout = $this->plugin->Config()->get('barcodeLabelPrintingPaperLayout');

        // Get the available template
        $element = Shopware()->Models()->getRepository('\Shopware\Models\Config\Element')->findOneBy(array(
            'name' => 'barcodeLabelPrintingPaperLayout',
            'form' => $this->plugin->Form()->getId()
        ));

        // Prepare the data
        $templates = array();
        $options = $element->getOptions();
        foreach ($options['store'] as $template) {
            $dimensions = explode('x', $template[0]);
            $templates[] = array(
                'name' => $template[0],
                'title' => $template[1],
                'default' => ($defaultLayout == $template[0]),
                'numCols' => intval($dimensions[0]),
                'numRows' => intval($dimensions[1])
            );
        }

        return $templates;
    }

    /**
     * Checks if a template with the given name exists.
     *
     * @param $layoutName
     */
    protected function isValidGridLabelTemplate($layoutName)
    {
        $templates = $this->getGridLabelTemplates();
        foreach ($templates as $template) {
            if ($template['name'] == $layoutName) {
                return true;
            }
        }
        return false;
    }
}
