<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

$pluginsRootPath = Shopware()->AppPath() . 'Plugins/';

/**
 * Returns the full path to the plugin file/directory at `$pluginFilePath`, depending on whether the respective plugin
 * is located in the 'Local' or 'Community' plugin directory.
 *
 * @param string $pluginFilePath
 * @return string|bool The full path to the plugin file/directory or `false`, if the file could not be found.
 */
return function ($pluginFilePath) use ($pluginsRootPath) {
    if (file_exists($pluginsRootPath . 'Local/' . $pluginFilePath)) {
        return $pluginsRootPath . 'Local/' . $pluginFilePath;
    } elseif (file_exists($pluginsRootPath . 'Community/' . $pluginFilePath)) {
        return $pluginsRootPath . 'Community/' . $pluginFilePath;
    }

    return false;
};
