<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Subscriber\Backend;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base as ViisonCommonSubscriberBase;
use Enlight_Controller_Action;

/**
 * Class Index
 *
 * This class is used to register the onPostDispatchSecureIndex subscriber
 */
class Index extends ViisonCommonSubscriberBase
{

    /** @var string The icon name, by default this icon name is used in all Adapter */
    protected $iconName = 'plugin.png';
    /** @var string The Shopware plugin folder Path (looking from the root path) */
    protected $shopwarePluginsFolder = '/engine/Shopware/Plugins/';

    /**
     * Returns the plugin icon path used for the Menu entry
     *
     * @param \Enlight_Event_EventArgs $args
     * @param $plugin
     * @return string
     */
    public function getPluginIconPath(\Enlight_Event_EventArgs $args, $plugin)
    {
        return $args->getSubject()->Request()->getBasePath() . $this->shopwarePluginsFolder .
               $plugin->getSource() . '/' . $plugin->getNamespace() . '/' . $plugin->getName() . '/' . $this->iconName;
    }

}