<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Subscriber;

use Shopware\Components\DependencyInjection\Container;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Services as ServicesSubscriber;
use Shopware\Plugins\ViisonShippingCommon\Components\AddressFactory;
use Shopware\Plugins\ViisonShippingCommon\Components\CurrencyConverter;
use Shopware\Plugins\ViisonShippingCommon\Components\Export;
use Shopware\Plugins\ViisonShippingCommon\Components\OrderDocumentCollectorService;
use Shopware\Plugins\ViisonShippingCommon\Components\OrderShipmentDataGeneratorService;
use Shopware\Plugins\ViisonShippingCommon\Components\ReturnLabelCreation\ReturnLabelCreatorFactoryService;
use Shopware\Plugins\ViisonShippingCommon\Components\ShippingPluginConfigReaderService;

class Services extends ServicesSubscriber
{
    /**
     * @inheritdoc
     */
    public static function getServices()
    {
        return array(
            'viison_shipping_common.order_document_collector' => function (Container $container) {
                return new OrderDocumentCollectorService(
                    $container->get('models'),
                    $container->get('viison_common.document_file_storage_service')
                );
            },
            'viison_shipping_common.dispatch_data' => 'Shopware\Plugins\ViisonShippingCommon\Components\ViisonShippingCommonDispatchData',
            'viison_shipping_common.plugin_config_importer' => function (Container $container) {
                return new ShippingPluginConfigReaderService(
                    $container->get('db')
                );
            },
            'viison_shipping_common.export_information' => function (Container $container) {
                return new Export\InformationService(
                    $container->get('db'),
                    $container->get('models'),
                    $container->get('config'),
                    $container->get('ViisonShippingCommonDispatchData')
                );
            },
            'viison_shipping_common.order_shipment_data_generator_service' => function (Container $container) {
                return new OrderShipmentDataGeneratorService(
                    $container->get('db')
                );
            },
            'viison_shipping_common.return_label_creator_factory_service' => function (Container $container) {
                return new ReturnLabelCreatorFactoryService(
                    $container->get('models'),
                    $container->get('viison_shipping_common.order_shipment_data_generator_service')
                );
            },
            'viison_shipping_common.address_factory' => function (Container $container) {
                return new AddressFactory(
                    $container->get('models')
                );
            },
            'viison_shipping_common.currency_converter' => function (Container $container) {
                return new CurrencyConverter(
                    $container->get('models')->getRepository('Shopware\\Models\\Shop\\Currency')
                );
            },
            // Legacy service names
            'ViisonShippingCommonDispatchData' => 'Shopware\Plugins\ViisonShippingCommon\Components\ViisonShippingCommonDispatchData',
        );
    }
}
