<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonShippingCommon\Subscriber;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;
use \Shopware_Components_Plugin_Bootstrap as PluginBootstrap;

class ShippingProviders extends Base
{
    /**
     * @var string $shippingProviderClass
     */
    protected $shippingProviderClass;

    /**
     * @param PluginBootstrap $pluginBootstrap
     * @param string $shippingProviderClass
     */
    public function __construct(PluginBootstrap $pluginBootstrap, $shippingProviderClass)
    {
        parent::__construct($pluginBootstrap);
        $this->shippingProviderClass = $shippingProviderClass;
    }

    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return array(
            'Shopware_Plugins_ViisonPickwareMobile_CollectShippingProviders' => 'onCollectShippingProviders',
            'Shopware_Plugins_ViisonShippingCommon_CollectShippingProviders' => 'onCollectShippingProviders'
        );
    }

    /**
     * Creates and returns a new shipping provider instance.
     *
     * @param \Enlight_Event_EventArgs $args
     * @return \ViisonShippingCommon_Classes_ShippingProvider
     */
    public function onCollectShippingProviders(\Enlight_Event_EventArgs $args)
    {
        return ($this->shippingProviderClass) ? new $this->shippingProviderClass() : null;
    }
}
