// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

// Since we do not want to slow down the loading process by synchronously loading the whole Config subapplication,
// we need to supply the ExtJS loader ourselves with the information how the Javascript code of it can be loaded
Ext.Loader.config.paths['Shopware.apps.Config'] = '{url controller="Config" action=load}';
Ext.Loader.config.suffixes['Shopware.apps.Config'] = '';

Ext.define('Shopware.apps.ViisonShippingCommonConfig', {

    /**
     * Extends from the general sub-application controller, which handles
     * the sub-application behavior and the event bus.
     */
    extend: 'Enlight.app.SubApplication',

    /**
     * The name of the module.
     */
    name: 'Shopware.apps.ViisonShippingCommonConfig',

    loadPath: '',

    requires: [
        'Shopware.apps.Config.view.main.Fieldset'
    ]

}, function() {
    delete Ext.Loader.config.paths['Shopware.apps.Config'];
});
