// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

//{namespace name=backend/viison_shipping_common_free_form_labels/main}
Ext.define('Shopware.apps.ViisonShippingCommonFreeFormLabels.controller.Main', {

    extend: 'Shopware.apps.ViisonShippingCommonOrder.controller.ShippingLabels',

    /**
     * Creates the necessary event listeners for this specific
     * controller and creates the window for this sub-application.
     */
    init: function() {
        var me = this;

        me.callParent(arguments);

        me.countriesStore = Ext.create('Shopware.apps.ViisonShippingCommonFreeFormLabels.store.Country').load({
            callback: function() {
                var mainWindow = me.getView('Window').create();
                mainWindow.show();
            }
        });
    }

});
